/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WByteArrayComparable;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class WCompareFilter
extends WFilter {
    protected CompareOp compareOp;
    protected WByteArrayComparable comparator;

    public WCompareFilter() {
    }

    public WCompareFilter(CompareOp compareOp, WByteArrayComparable comparator) {
        this.compareOp = compareOp;
        this.comparator = comparator;
    }

    public CompareOp getOperator() {
        return this.compareOp;
    }

    public WByteArrayComparable getComparator() {
        return this.comparator;
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.compareOp = CompareOp.valueOf(WritableUtils.readString(in));
        this.comparator = WByteArrayComparable.read(in);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.compareOp.name());
        WByteArrayComparable.write(out, this.comparator);
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.compareOp.name(), Bytes.toStringBinary(this.comparator.getValue()));
    }

    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER,
        NO_OP;

    }
}

