/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.schema.DataType;

public class ColumnSchema
implements Comparable<ColumnSchema> {
    private byte[] familyName;
    private byte[] columnName;
    private DataType type;
    private Integer maxLength = null;
    private Integer scale = null;

    public ColumnSchema() {
    }

    public ColumnSchema(byte[] columnName, DataType type) {
        this(null, columnName, type);
    }

    public ColumnSchema(byte[] columnName, DataType type, int maxLength) {
        this(null, columnName, type, maxLength);
    }

    public ColumnSchema(byte[] columnName, DataType type, int precision, int scale) {
        this(null, columnName, type, precision, scale);
    }

    public ColumnSchema(String columnName, DataType type) {
        this(null, Bytes.toBytes(columnName), type);
    }

    public ColumnSchema(String columnName, DataType type, int length) {
        this(null, Bytes.toBytes(columnName), type, length);
    }

    public ColumnSchema(String columnName, DataType type, int precision, int scale) {
        this(null, Bytes.toBytes(columnName), type, precision, scale);
    }

    public ColumnSchema(String familyName, String columnName, DataType type) {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), type);
    }

    public ColumnSchema(String familyName, String columnName, DataType type, int length) {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), type, length);
    }

    public ColumnSchema(String familyName, String columnName, DataType type, int precision, int scale) {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), type, precision, scale);
    }

    public ColumnSchema(byte[] familyName, byte[] columnName, DataType type) {
        this.setFamilyName(familyName);
        this.setColumnName(columnName);
        this.setDataType(type);
    }

    public ColumnSchema(byte[] familyName, byte[] columnName, DataType type, int maxLength) {
        if (type != DataType.BINARY) {
            throw new IllegalArgumentException("Only DataType#BINARY type is supported by this constructor.");
        }
        this.setFamilyName(familyName);
        this.setColumnName(columnName);
        this.setDataType(type, maxLength);
    }

    public ColumnSchema(byte[] familyName, byte[] columnName, DataType type, int precision, int scale) {
        if (type != DataType.DECIMAL) {
            throw new IllegalArgumentException("Only DataType#DECIMAL type is supported by this constructor.");
        }
        this.setFamilyName(familyName);
        this.setColumnName(columnName);
        this.setDataType(type, precision, scale);
    }

    public void setFamilyName(byte[] familyName) {
        this.familyName = (byte[])(familyName == null || familyName.length == 0 ? null : familyName);
    }

    public void setFamilyName(String familyName) {
        this.setFamilyName(Bytes.toBytes(familyName));
    }

    public byte[] getFamilyName() {
        return this.familyName;
    }

    public String getFamilyNameAsString() {
        return Bytes.toString(this.familyName);
    }

    public void setColumnName(byte[] columnName) {
        if (columnName == null || columnName.length == 0) {
            throw new IllegalArgumentException("Column name must not be null or empty.");
        }
        this.columnName = columnName;
    }

    public void setColumnName(String columnName) {
        this.setColumnName(Bytes.toBytes(columnName));
    }

    public byte[] getColumnName() {
        return this.columnName;
    }

    public String getColumnNameAsString() {
        return Bytes.toString(this.columnName);
    }

    public void setDataType(DataType type) {
        if (type == null) {
            throw new IllegalArgumentException("Column data type must not be null.");
        }
        if (DataTypeUtils.needLength(type)) {
            throw new IllegalArgumentException("You must specify length for type " + (Object)((Object)type));
        }
        this.type = type;
    }

    public void setDataType(DataType type, int maxLength) {
        if (type != DataType.BINARY) {
            throw new IllegalArgumentException("You cannot specify length for type " + (Object)((Object)type));
        }
        DataTypeUtils.validateLength(maxLength);
        this.type = type;
        this.maxLength = maxLength;
    }

    public void setDataType(DataType type, int precision, int scale) {
        if (type != DataType.DECIMAL) {
            throw new IllegalArgumentException("You cannot specify length for type " + (Object)((Object)type));
        }
        DataTypeUtils.validatePrecisionAndScale(precision, scale);
        this.type = type;
        this.maxLength = precision;
        this.scale = scale;
    }

    public DataType getDataType() {
        return this.type;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getPrecision() {
        return this.maxLength;
    }

    public Integer getScale() {
        return this.scale;
    }

    public String toString() {
        return SchemaUtils.getFullColumnName(this.familyName, this.columnName) + " " + this.type.toString() + DataTypeUtils.lengthToString(this.maxLength, this.scale);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ColumnSchema)) {
            return false;
        }
        return this.compareTo((ColumnSchema)obj) == 0;
    }

    @Override
    public int compareTo(ColumnSchema other) {
        int result = Bytes.compareTo(this.familyName, other.familyName);
        if (result == 0) {
            result = Bytes.compareTo(this.columnName, other.columnName);
        }
        if (result == 0) {
            result = this.type == null ? (other.type == null ? 0 : -1) : this.type.compareTo(other.type);
        }
        return result;
    }
}

