/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.CoveredColumnType;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.util.ArrayList;
import java.util.Map;

public class DescriptorUtils {
    public static LindormTableDescriptor buildLindormTableDescriptor(TableMeta tableMeta) {
        LindormTableDescriptor desc = new LindormTableDescriptor();
        desc.setName(tableMeta.getTableName());
        desc.setMetaVersion(tableMeta.getMetaVersion());
        ArrayList<ColumnFamilyDescriptor> temp = new ArrayList<ColumnFamilyDescriptor>(tableMeta.getFamilies());
        desc.setFamilies(temp);
        ArrayList<PrimaryKeySchema> pkColumns = CollectionUtils.newArrayListWithCapacity(tableMeta.getPkColumns().size());
        ArrayList<ColumnSchema> nonPkColumns = CollectionUtils.newArrayListWithCapacity(tableMeta.getNonPkColumns().size());
        SchemaUtils.convertInternalSchemaToClientSchema(tableMeta.getAllColumns(), pkColumns, nonPkColumns);
        desc.setPkColumns(pkColumns);
        desc.setNonPkColumns(nonPkColumns);
        desc.setFamilyAttributes(tableMeta.getFamilyAttributes());
        desc.setTableAttributes(tableMeta.getTableAttributes());
        Map<String, TableMeta> indexMetas = tableMeta.getIndexMetas();
        if (!indexMetas.isEmpty()) {
            ArrayList<LindormIndexDescriptor> indexDesc = CollectionUtils.newArrayListWithCapacity(indexMetas.size());
            for (TableMeta indexMeta : indexMetas.values()) {
                indexDesc.add(DescriptorUtils.buildLindormIndexDescriptor(indexMeta));
            }
            desc.setIndexes(indexDesc);
            desc.setIndexNames(tableMeta.getIndexLogicalNames());
            desc.setIndexIds(tableMeta.getIndexIds());
            desc.setSilenceIndex(tableMeta.getSilenceIndexMap());
        }
        return desc;
    }

    public static LindormIndexDescriptor buildLindormIndexDescriptor(TableMeta tableMeta) {
        byte[] family;
        ColumnKey columnKey;
        LindormIndexDescriptor desc = new LindormIndexDescriptor(tableMeta.getIndexName(), tableMeta.getParentName());
        desc.setTableType(tableMeta.getType());
        desc.setFamilyAttributes(tableMeta.getFamilyAttributes());
        desc.setTableAttributes(tableMeta.getTableAttributes());
        desc.setMetaVersion(tableMeta.getMetaVersion());
        desc.where(tableMeta.getIndexCondition());
        for (LColumn lColumn : tableMeta.getPkColumns()) {
            columnKey = lColumn.getDataColumnKey();
            if (null == columnKey) continue;
            family = SchemaUtils.isDefaultFamily(columnKey.getFamily()) ? null : columnKey.getFamily();
            columnKey.setFamily(family);
            SortOrder sortOrder = lColumn.getSortOrder();
            IndexedColumnSchema indexedColumnSchema = new IndexedColumnSchema(columnKey, sortOrder);
            indexedColumnSchema.setHashed(lColumn.isHashed());
            desc.addIndexedColumns(indexedColumnSchema);
        }
        if (tableMeta.getCoveredColumnType() == CoveredColumnType.ALL) {
            desc.addCoveredColumn(LindormIndexDescriptor.COVERED_ALL_COLUMNS_IN_SCHEMA);
        } else if (tableMeta.getCoveredColumnType() == CoveredColumnType.DYNAMIC) {
            desc.addCoveredColumn(LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS);
        } else {
            for (LColumn lColumn : tableMeta.getNonPkColumns()) {
                if (SchemaUtils.isDefaultColumn(lColumn.getColumnKey().getQualifier())) continue;
                columnKey = lColumn.getDataColumnKey();
                family = SchemaUtils.isDefaultFamily(columnKey.getFamily()) ? null : columnKey.getFamily();
                columnKey.setFamily(family);
                desc.addCoveredColumn(columnKey);
            }
        }
        if (null != tableMeta.getIndexState()) {
            desc.setIndexState(tableMeta.getIndexState());
        }
        desc.setStorePkNulls(tableMeta.isStorePkNulls());
        return desc;
    }
}

