/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class PrimaryKeySchema
implements Comparable<PrimaryKeySchema> {
    private byte[] name;
    private DataType type;
    private Integer maxLength = null;
    private Integer scale = null;
    private SortOrder sortOrder;
    private boolean hashed = false;

    public PrimaryKeySchema() {
    }

    public PrimaryKeySchema(byte[] name, DataType type) {
        this(name, type, SortOrder.getDefault());
    }

    public PrimaryKeySchema(byte[] name, DataType type, boolean hashed) {
        this(name, type, SortOrder.getDefault(), hashed);
    }

    public PrimaryKeySchema(String name, DataType type) {
        this(Bytes.toBytes(name), type, SortOrder.getDefault());
    }

    public PrimaryKeySchema(String name, DataType type, SortOrder sortOrder) {
        this(Bytes.toBytes(name), type, sortOrder);
    }

    public PrimaryKeySchema(byte[] name, DataType type, SortOrder sortOrder, boolean hashed) {
        this(name, type, sortOrder);
        this.setHashed(hashed);
    }

    public PrimaryKeySchema(byte[] name, DataType type, int maxLength) {
        this(name, type, maxLength, SortOrder.getDefault());
    }

    public PrimaryKeySchema(byte[] name, DataType type, int precision, int scale) {
        this(name, type, precision, scale, SortOrder.getDefault());
    }

    public PrimaryKeySchema(String name, DataType type, int maxLength) {
        this(Bytes.toBytes(name), type, maxLength, SortOrder.getDefault());
    }

    public PrimaryKeySchema(String name, DataType type, int precision, int scale) {
        this(Bytes.toBytes(name), type, precision, scale, SortOrder.getDefault());
    }

    public PrimaryKeySchema(String name, DataType type, int maxLength, SortOrder sortOrder) {
        this(Bytes.toBytes(name), type, maxLength, sortOrder);
    }

    public PrimaryKeySchema(String name, DataType type, int precision, int scale, SortOrder sortOrder) {
        this(Bytes.toBytes(name), type, precision, scale, sortOrder);
    }

    public PrimaryKeySchema(byte[] name, DataType type, int maxLength, SortOrder sortOrder) {
        if (type != DataType.BINARY) {
            throw new IllegalArgumentException("Only DataType#BINARY type is supported by this constructor.");
        }
        this.setName(name);
        this.setSortOrder(sortOrder);
        this.setType(type, maxLength);
    }

    public PrimaryKeySchema(byte[] name, DataType type, SortOrder sortOrder) {
        this.setName(name);
        this.setType(type);
        this.setSortOrder(sortOrder);
    }

    public PrimaryKeySchema(byte[] name, DataType type, int precision, int scale, SortOrder sortOrder) {
        if (type != DataType.DECIMAL) {
            throw new IllegalArgumentException("Only DataType#DECIMAL type is supported by this constructor.");
        }
        this.setName(name);
        this.setSortOrder(sortOrder);
        this.setType(type, precision, scale);
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return Bytes.toString(this.name);
    }

    public void setName(String name) {
        this.setName(Bytes.toBytes(name));
    }

    public void setName(byte[] name) {
        if (name == null || name.length == 0) {
            throw new IllegalArgumentException("Primary key column name must not be null or empty.");
        }
        this.name = name;
    }

    public DataType getDataType() {
        return this.type;
    }

    public void setType(DataType type) {
        if (type == null) {
            throw new IllegalArgumentException("Primary key's data type must not be null.");
        }
        if (DataTypeUtils.needLength(type)) {
            throw new IllegalArgumentException("You must specify length for type " + (Object)((Object)type));
        }
        this.type = type;
    }

    public void setType(DataType type, int maxLength) {
        if (type != DataType.BINARY) {
            throw new IllegalArgumentException("You cannot specify length for type " + (Object)((Object)type));
        }
        DataTypeUtils.validateLength(maxLength);
        this.type = type;
        this.maxLength = maxLength;
    }

    public void setType(DataType type, int precision, int scale) {
        if (type != DataType.DECIMAL) {
            throw new IllegalArgumentException("You can only specify precision/scale for DECIMAL, not " + (Object)((Object)type));
        }
        DataTypeUtils.validatePrecisionAndScale(precision, scale);
        this.type = type;
        this.maxLength = precision;
        this.scale = scale;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getPrecision() {
        return this.maxLength;
    }

    public Integer getScale() {
        return this.scale;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (sortOrder == null) {
            throw new IllegalArgumentException("Primary key's sort order must not be null.");
        }
        this.sortOrder = sortOrder;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(Bytes.toString(this.name));
        str.append(" ");
        str.append((Object)this.type);
        str.append(DataTypeUtils.lengthToString(this.maxLength, this.scale));
        if (this.sortOrder == SortOrder.DESC) {
            str.append(" ");
            str.append(this.sortOrder.toString());
        }
        str.append(this.hashed ? " hashed:true" : "");
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PrimaryKeySchema)) {
            return false;
        }
        return this.compareTo((PrimaryKeySchema)obj) == 0;
    }

    @Override
    public int compareTo(PrimaryKeySchema other) {
        int result = Bytes.compareTo(this.name, other.name);
        if (result == 0) {
            result = this.type == null ? (other.type == null ? 0 : -1) : this.type.compareTo(other.type);
        }
        if (result == 0) {
            result = this.sortOrder == null ? (other.sortOrder == null ? 0 : -1) : this.sortOrder.compareTo(other.sortOrder);
        }
        return result;
    }

    public void setHashed(boolean hashed) {
        this.hashed = hashed;
    }

    public boolean isHashed() {
        return this.hashed;
    }
}

