/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.esri.core.geometry;

import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.AttributeStreamOfInt8;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.GeometryException;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Line;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MultiPathImpl;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Point2D;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Segment;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.VertexDescription;

final class SegmentIteratorImpl {
    protected Line m_line;
    protected Segment m_currentSegment;
    protected Point2D m_dummyPoint;
    protected int m_currentPathIndex;
    protected int m_nextPathIndex;
    protected int m_prevPathIndex;
    protected int m_currentSegmentIndex;
    protected int m_nextSegmentIndex;
    protected int m_prevSegmentIndex;
    protected int m_segmentCount;
    protected int m_pathBegin;
    protected MultiPathImpl m_parent;
    protected boolean m_bCirculator;
    protected boolean m_bNeedsUpdate;

    public SegmentIteratorImpl(MultiPathImpl parent) {
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = 0;
        this.m_nextPathIndex = 0;
        this.m_currentPathIndex = -1;
        this.m_parent = parent;
        this.m_segmentCount = this._getSegmentCount(this.m_nextPathIndex);
        this.m_bCirculator = false;
        this.m_currentSegment = null;
        this.m_pathBegin = -1;
        this.m_dummyPoint = new Point2D();
    }

    public SegmentIteratorImpl(MultiPathImpl parent, int pointIndex) {
        if (pointIndex < 0 || pointIndex >= parent.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        this.m_currentSegmentIndex = -1;
        int path = parent.getPathIndexFromPointIndex(pointIndex);
        this.m_nextSegmentIndex = pointIndex - parent.getPathStart(path);
        this.m_nextPathIndex = path + 1;
        this.m_currentPathIndex = path;
        this.m_parent = parent;
        this.m_segmentCount = this._getSegmentCount(this.m_currentPathIndex);
        this.m_bCirculator = false;
        this.m_currentSegment = null;
        this.m_pathBegin = this.m_parent.getPathStart(this.m_currentPathIndex);
        this.m_dummyPoint = new Point2D();
    }

    public SegmentIteratorImpl(MultiPathImpl parent, int pathIndex, int segmentIndex) {
        int d;
        if (pathIndex < 0 || pathIndex >= parent.getPathCount() || segmentIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = d = parent.isClosedPath(pathIndex) ? 0 : 1;
        if (segmentIndex >= parent.getPathSize(pathIndex) - d) {
            throw new IndexOutOfBoundsException();
        }
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = segmentIndex;
        this.m_currentPathIndex = pathIndex;
        this.m_nextPathIndex = this.m_nextSegmentIndex + 1;
        this.m_parent = parent;
        this.m_segmentCount = this._getSegmentCount(this.m_nextPathIndex);
        this.m_bCirculator = false;
        this.m_currentSegment = null;
        this.m_pathBegin = this.m_parent.getPathStart(this.m_currentPathIndex);
        this.m_dummyPoint = new Point2D();
    }

    void resetTo(SegmentIteratorImpl src) {
        if (this.m_parent != src.m_parent) {
            throw new GeometryException("invalid_call");
        }
        this.m_currentSegmentIndex = src.m_currentSegmentIndex;
        this.m_nextSegmentIndex = src.m_nextSegmentIndex;
        this.m_currentPathIndex = src.m_currentPathIndex;
        this.m_nextPathIndex = src.m_nextPathIndex;
        this.m_segmentCount = src.m_segmentCount;
        this.m_bCirculator = src.m_bCirculator;
        this.m_pathBegin = src.m_pathBegin;
        this.m_currentSegment = null;
    }

    public Segment nextCurve() {
        return null;
    }

    public Segment nextSegment() {
        if (this.m_currentSegmentIndex != this.m_nextSegmentIndex) {
            this._updateSegment();
        }
        if (this.m_bCirculator) {
            this.m_nextSegmentIndex = (this.m_nextSegmentIndex + 1) % this.m_segmentCount;
        } else {
            if (this.m_nextSegmentIndex == this.m_segmentCount) {
                throw new IndexOutOfBoundsException();
            }
            ++this.m_nextSegmentIndex;
        }
        return this.m_currentSegment;
    }

    public Segment previousSegment() {
        if (this.m_bCirculator) {
            this.m_nextSegmentIndex = (this.m_segmentCount + this.m_nextSegmentIndex - 1) % this.m_segmentCount;
        } else {
            if (this.m_nextSegmentIndex == 0) {
                throw new IndexOutOfBoundsException();
            }
            --this.m_nextSegmentIndex;
        }
        if (this.m_nextSegmentIndex != this.m_currentSegmentIndex) {
            this._updateSegment();
        }
        return this.m_currentSegment;
    }

    public void resetToFirstSegment() {
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = 0;
    }

    public void resetToLastSegment() {
        this.m_nextSegmentIndex = this.m_segmentCount;
        this.m_currentSegmentIndex = -1;
    }

    public void resetToVertex(int vertexIndex) {
        this.resetToVertex(vertexIndex, -1);
    }

    public void resetToVertex(int vertexIndex, int _pathIndex) {
        int start;
        if (this.m_currentPathIndex >= 0 && this.m_currentPathIndex < this.m_parent.getPathCount() && vertexIndex >= (start = this._getPathBegin()) && vertexIndex < this.m_parent.getPathEnd(this.m_currentPathIndex)) {
            this.m_currentSegmentIndex = -1;
            this.m_nextSegmentIndex = vertexIndex - start;
            return;
        }
        int path_index = _pathIndex >= 0 && _pathIndex < this.m_parent.getPathCount() && vertexIndex >= this.m_parent.getPathStart(_pathIndex) && vertexIndex < this.m_parent.getPathEnd(_pathIndex) ? _pathIndex : this.m_parent.getPathIndexFromPointIndex(vertexIndex);
        this.m_nextPathIndex = path_index + 1;
        this.m_currentPathIndex = path_index;
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = vertexIndex - this.m_parent.getPathStart(path_index);
        this.m_segmentCount = this._getSegmentCount(path_index);
        this.m_pathBegin = this.m_parent.getPathStart(this.m_currentPathIndex);
    }

    public boolean nextPath() {
        this.m_currentPathIndex = this.m_nextPathIndex++;
        if (this.m_currentPathIndex >= this.m_parent.getPathCount()) {
            return false;
        }
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = 0;
        this.m_segmentCount = this._getSegmentCount(this.m_currentPathIndex);
        this.m_pathBegin = this.m_parent.getPathStart(this.m_currentPathIndex);
        return true;
    }

    public boolean previousPath() {
        if (this.m_nextPathIndex == 0) {
            return false;
        }
        --this.m_nextPathIndex;
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = 0;
        this.m_segmentCount = this._getSegmentCount(this.m_nextPathIndex);
        this.m_currentPathIndex = this.m_nextPathIndex;
        this.m_pathBegin = this.m_parent.getPathStart(this.m_currentPathIndex);
        this.resetToLastSegment();
        return true;
    }

    public void resetToFirstPath() {
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = -1;
        this.m_segmentCount = -1;
        this.m_nextPathIndex = 0;
        this.m_currentPathIndex = -1;
        this.m_pathBegin = -1;
    }

    public void resetToLastPath() {
        this.m_nextPathIndex = this.m_parent.getPathCount();
        this.m_currentPathIndex = -1;
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = -1;
        this.m_segmentCount = -1;
        this.m_pathBegin = -1;
    }

    public void resetToPath(int pathIndex) {
        if (pathIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.m_nextPathIndex = pathIndex;
        this.m_currentPathIndex = -1;
        this.m_currentSegmentIndex = -1;
        this.m_nextSegmentIndex = -1;
        this.m_segmentCount = -1;
        this.m_pathBegin = -1;
    }

    public int _getSegmentCount(int pathIndex) {
        if (this.m_parent.isEmptyImpl()) {
            return 0;
        }
        int d = 1;
        if (this.m_parent.isClosedPath(pathIndex)) {
            d = 0;
        }
        return this.m_parent.getPathSize(pathIndex) - d;
    }

    public boolean isClosingSegment() {
        return this.m_currentSegmentIndex == this.m_segmentCount - 1 && this.m_parent.isClosedPath(this.m_currentPathIndex);
    }

    public void setCirculator(boolean bYesNo) {
        this.m_bCirculator = bYesNo;
    }

    public int getPathIndex() {
        return this.m_currentPathIndex;
    }

    public int getStartPointIndex() {
        return this._getPathBegin() + this.m_currentSegmentIndex;
    }

    public int _getPathBegin() {
        return this.m_parent.getPathStart(this.m_currentPathIndex);
    }

    public int getEndPointIndex() {
        if (this.isClosingSegment()) {
            return this.m_parent.getPathStart(this.m_currentPathIndex);
        }
        return this.getStartPointIndex() + 1;
    }

    public boolean isFirstSegmentInPath() {
        return this.m_currentSegmentIndex == 0;
    }

    public boolean isLastSegmentInPath() {
        return this.m_currentSegmentIndex == this.m_segmentCount - 1;
    }

    public boolean hasNextSegment() {
        return this.m_nextSegmentIndex < this.m_segmentCount;
    }

    public boolean hasPreviousSegment() {
        return this.m_nextSegmentIndex > 0;
    }

    public SegmentIteratorImpl copy() {
        SegmentIteratorImpl clone = new SegmentIteratorImpl(this.m_parent);
        clone.m_currentSegmentIndex = this.m_currentSegmentIndex;
        clone.m_nextSegmentIndex = this.m_nextSegmentIndex;
        clone.m_segmentCount = this.m_segmentCount;
        clone.m_currentPathIndex = this.m_currentPathIndex;
        clone.m_nextPathIndex = this.m_nextPathIndex;
        clone.m_parent = this.m_parent;
        clone.m_bCirculator = this.m_bCirculator;
        return clone;
    }

    public void _updateSegment() {
        if (this.m_nextSegmentIndex < 0 || this.m_nextSegmentIndex >= this.m_segmentCount) {
            throw new IndexOutOfBoundsException();
        }
        this.m_currentSegmentIndex = this.m_nextSegmentIndex;
        int startVertexIndex = this.getStartPointIndex();
        this.m_parent._verifyAllStreams();
        AttributeStreamOfInt8 segFlagStream = this.m_parent.getSegmentFlagsStreamRef();
        int segFlag = 1;
        if (segFlagStream != null) {
            segFlag = segFlagStream.read(startVertexIndex) & 7;
        }
        VertexDescription vertexDescr = this.m_parent.getDescription();
        switch (segFlag) {
            case 1: {
                if (this.m_line == null) {
                    this.m_line = new Line();
                }
                this.m_currentSegment = this.m_line;
                break;
            }
            case 2: {
                throw GeometryException.GeometryInternalError();
            }
            case 4: {
                throw GeometryException.GeometryInternalError();
            }
            default: {
                throw GeometryException.GeometryInternalError();
            }
        }
        this.m_currentSegment.assignVertexDescription(vertexDescr);
        int endVertexIndex = this.getEndPointIndex();
        this.m_parent.getXY(startVertexIndex, this.m_dummyPoint);
        this.m_currentSegment.setStartXY(this.m_dummyPoint);
        this.m_parent.getXY(endVertexIndex, this.m_dummyPoint);
        this.m_currentSegment.setEndXY(this.m_dummyPoint);
        int nattr = vertexDescr.getAttributeCount();
        for (int i = 1; i < nattr; ++i) {
            int semantics = vertexDescr.getSemantics(i);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int ord = 0; ord < ncomp; ++ord) {
                double vs = this.m_parent.getAttributeAsDbl(semantics, startVertexIndex, ord);
                this.m_currentSegment.setStartAttribute(semantics, ord, vs);
                double ve = this.m_parent.getAttributeAsDbl(semantics, endVertexIndex, ord);
                this.m_currentSegment.setEndAttribute(semantics, ord, ve);
            }
        }
    }

    boolean isLastPath() {
        return this.m_currentPathIndex == this.m_parent.getPathCount() - 1;
    }
}

