/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll;

import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.SketchesArgumentException;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll.BucketIterator;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll.CompressedBucketUtils;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll.Fields;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll.FieldsFactory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll.HllUtils;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll.OnHeapHash;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll.OnHeapImmutableCompactFields;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hll.Preamble;

final class OnHeapHashFields
implements Fields {
    private final Preamble preamble;
    private final FieldsFactory denseFactory;
    private final int switchToDenseSize;
    private final OnHeapHash hasher;
    private int growthBound;

    public OnHeapHashFields(Preamble preamble, int startSize, int switchToDenseSize, FieldsFactory denseFactory) {
        this.preamble = preamble;
        this.denseFactory = denseFactory;
        this.hasher = new OnHeapHash(startSize);
        this.switchToDenseSize = switchToDenseSize;
        this.growthBound = 3 * (startSize >>> 2);
    }

    @Override
    public Preamble getPreamble() {
        return this.preamble;
    }

    @Override
    public Fields updateBucket(int key, byte val, Fields.UpdateCallback callback) {
        this.hasher.updateBucket(key, val, callback);
        if (this.hasher.getNumElements() >= this.growthBound) {
            int[] fields = this.hasher.getFields();
            this.growthBound = 3 * (fields.length >>> 2);
            if (fields.length == this.switchToDenseSize) {
                Fields retVal = this.denseFactory.make(this.preamble);
                BucketIterator iter2 = this.getBucketIterator();
                while (iter2.next()) {
                    retVal.updateBucket(iter2.getKey(), iter2.getValue(), NOOP_CB);
                }
                return retVal;
            }
            this.hasher.resetFields(fields.length << 1);
            this.hasher.boostrap(fields);
        }
        return this;
    }

    @Override
    public int intoByteArray(byte[] array, int offset) {
        int numBytesNeeded = this.numBytesToSerialize();
        if (array.length - offset < numBytesNeeded) {
            throw new SketchesArgumentException(String.format("array too small[%,d] < [%,d]", array.length - offset, numBytesNeeded));
        }
        array[offset] = 1;
        return this.hasher.intoByteArray(array, offset + 1);
    }

    @Override
    public int numBytesToSerialize() {
        return 1 + this.hasher.numBytesToSerialize();
    }

    @Override
    public Fields toCompact() {
        return OnHeapImmutableCompactFields.fromFields(this);
    }

    @Override
    public BucketIterator getBucketIterator() {
        return this.hasher.getBucketIterator();
    }

    @Override
    public Fields unionInto(Fields recipient, Fields.UpdateCallback cb) {
        return recipient.unionBucketIterator(this.getBucketIterator(), cb);
    }

    @Override
    public Fields unionBucketIterator(BucketIterator iter2, Fields.UpdateCallback callback) {
        return HllUtils.unionBucketIterator(this, iter2, callback);
    }

    @Override
    public Fields unionCompressedAndExceptions(byte[] compressed, int minVal, OnHeapHash exceptions, Fields.UpdateCallback cb) {
        return this.unionBucketIterator(CompressedBucketUtils.getBucketIterator(compressed, minVal, exceptions), cb);
    }
}

