/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.sampling;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.Memory;
import com.alibaba.lindorm.thirdparty.com.yahoo.memory.MemoryRegion;
import com.alibaba.lindorm.thirdparty.com.yahoo.memory.NativeMemory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.ArrayOfItemsSerDe;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Family;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.ResizeFactor;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.SketchesArgumentException;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.SketchesStateException;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Util;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.sampling.PreambleUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.sampling.SamplingUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.sampling.VersionConverter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public final class ReservoirItemsSketch<T> {
    private static final int MIN_LG_ARR_ITEMS = 4;
    private static final long MAX_ITEMS_SEEN = 0xFFFFFFFFFFFFL;
    private static final ResizeFactor DEFAULT_RESIZE_FACTOR = ResizeFactor.X8;
    private final int reservoirSize_;
    private int currItemsAlloc_;
    private long itemsSeen_;
    private final ResizeFactor rf_;
    private ArrayList<T> data_;

    private ReservoirItemsSketch(int k, ResizeFactor rf) {
        if (k < 2) {
            throw new SketchesArgumentException("k must be at least 2");
        }
        this.reservoirSize_ = k;
        this.rf_ = rf;
        this.itemsSeen_ = 0L;
        int ceilingLgK = Util.toLog2(Util.ceilingPowerOf2(this.reservoirSize_), "ReservoirItemsSketch");
        int initialLgSize = SamplingUtil.startingSubMultiple(ceilingLgK, this.rf_.lg(), 4);
        this.currItemsAlloc_ = SamplingUtil.getAdjustedSize(this.reservoirSize_, 1 << initialLgSize);
        this.data_ = new ArrayList(this.currItemsAlloc_);
    }

    private ReservoirItemsSketch(ArrayList<T> data, long itemsSeen, ResizeFactor rf, int k) {
        if (data == null) {
            throw new SketchesArgumentException("Instantiating sketch with null reservoir");
        }
        if (k < 2) {
            throw new SketchesArgumentException("Cannot instantiate sketch with reservoir size less than 2");
        }
        if (k < data.size()) {
            throw new SketchesArgumentException("Instantiating sketch with max size less than array length: " + k + " max size, array of length " + data.size());
        }
        if (itemsSeen >= (long)k && data.size() < k || itemsSeen < (long)k && (long)data.size() < itemsSeen) {
            throw new SketchesArgumentException("Instantiating sketch with too few samples. Items seen: " + itemsSeen + ", max reservoir size: " + k + ", data array length: " + data.size());
        }
        this.reservoirSize_ = k;
        this.currItemsAlloc_ = data.size();
        this.itemsSeen_ = itemsSeen;
        this.rf_ = rf;
        this.data_ = data;
    }

    private ReservoirItemsSketch(int k, int currItemsAlloc, long itemsSeen, ResizeFactor rf, ArrayList<T> data) {
        this.reservoirSize_ = k;
        this.currItemsAlloc_ = currItemsAlloc;
        this.itemsSeen_ = itemsSeen;
        this.rf_ = rf;
        this.data_ = data;
    }

    public static <T> ReservoirItemsSketch<T> getInstance(int k) {
        return new ReservoirItemsSketch<T>(k, DEFAULT_RESIZE_FACTOR);
    }

    public static <T> ReservoirItemsSketch<T> getInstance(int k, ResizeFactor rf) {
        return new ReservoirItemsSketch<T>(k, rf);
    }

    static <T> ReservoirItemsSketch<T> getInstance(ArrayList<T> data, long itemsSeen, ResizeFactor rf, int k) {
        return new ReservoirItemsSketch<T>(data, itemsSeen, rf, k);
    }

    public static <T> ReservoirItemsSketch<T> getInstance(Memory srcMem, ArrayOfItemsSerDe<T> serDe) {
        int k;
        long itemsSeen;
        boolean isEmpty;
        int serVer;
        ResizeFactor rf;
        int numPreLongs;
        Family.RESERVOIR.checkFamilyID(srcMem.getByte(2L));
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            numPreLongs = srcMem.getByte(0L) & 0x3F;
            rf = ResizeFactor.getRF(srcMem.getByte(0L) >>> 6);
            serVer = srcMem.getByte(1L) & 0xFF;
            isEmpty = (srcMem.getInt(3L) & 4) != 0;
            itemsSeen = isEmpty ? 0L : srcMem.getLong(8L);
            k = srcMem.getInt(4L);
        } else {
            Object memObj = srcMem.array();
            long memAddr = srcMem.getCumulativeOffset(0L);
            numPreLongs = PreambleUtil.extractPreLongs(memObj, memAddr);
            rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(memObj, memAddr));
            serVer = PreambleUtil.extractSerVer(memObj, memAddr);
            isEmpty = (PreambleUtil.extractFlags(memObj, memAddr) & 4) != 0;
            itemsSeen = isEmpty ? 0L : PreambleUtil.extractItemsSeenCount(memObj, memAddr);
            k = PreambleUtil.extractReservoirSize(memObj, memAddr);
        }
        boolean preLongsEqMin = numPreLongs == Family.RESERVOIR.getMinPreLongs();
        boolean preLongsEqMax = numPreLongs == Family.RESERVOIR.getMaxPreLongs();
        if (!preLongsEqMin & !preLongsEqMax) {
            throw new SketchesArgumentException("Possible corruption: Non-empty sketch with only " + Family.RESERVOIR.getMinPreLongs() + " preLong(s)");
        }
        if (serVer != 2) {
            if (serVer == 1) {
                srcMem = VersionConverter.convertSketch1to2(srcMem);
                k = PreambleUtil.extractReservoirSize(srcMem.array(), srcMem.getCumulativeOffset(0L));
            } else {
                throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 2: " + serVer);
            }
        }
        if (isEmpty) {
            return new ReservoirItemsSketch<T>(k, rf);
        }
        int preLongBytes = numPreLongs << 3;
        int allocatedItems = k;
        if (itemsSeen < (long)k) {
            int ceilingLgK = Util.toLog2(Util.ceilingPowerOf2(k), "getInstance");
            int minLgSize = Util.toLog2(Util.ceilingPowerOf2((int)itemsSeen), "getInstance");
            int initialLgSize = SamplingUtil.startingSubMultiple(ceilingLgK, rf.lg(), Math.max(minLgSize, 4));
            allocatedItems = SamplingUtil.getAdjustedSize(k, 1 << initialLgSize);
        }
        int itemsToRead = (int)Math.min((long)k, itemsSeen);
        T[] data = serDe.deserializeFromMemory(new MemoryRegion(srcMem, preLongBytes, srcMem.getCapacity() - (long)preLongBytes), itemsToRead);
        ArrayList<T> dataList = new ArrayList<T>(Arrays.asList(data));
        ReservoirItemsSketch<T> ris = new ReservoirItemsSketch<T>(dataList, itemsSeen, rf, k);
        ris.data_.ensureCapacity(allocatedItems);
        ris.currItemsAlloc_ = allocatedItems;
        return ris;
    }

    public int getK() {
        return this.reservoirSize_;
    }

    public long getN() {
        return this.itemsSeen_;
    }

    public int getNumSamples() {
        return (int)Math.min((long)this.reservoirSize_, this.itemsSeen_);
    }

    public void update(T item) {
        if (this.itemsSeen_ == 0xFFFFFFFFFFFFL) {
            throw new SketchesStateException("Sketch has exceeded capacity for total items seen: 281474976710655");
        }
        if (item == null) {
            return;
        }
        if (this.itemsSeen_ < (long)this.reservoirSize_) {
            if (this.itemsSeen_ >= (long)this.currItemsAlloc_) {
                this.growReservoir();
            }
            assert (this.itemsSeen_ < (long)this.currItemsAlloc_);
            this.data_.add(item);
            ++this.itemsSeen_;
        } else {
            ++this.itemsSeen_;
            if (SamplingUtil.rand.nextDouble() * (double)this.itemsSeen_ < (double)this.reservoirSize_) {
                int newSlot = SamplingUtil.rand.nextInt(this.reservoirSize_);
                this.data_.set(newSlot, item);
            }
        }
    }

    public T[] getSamples() {
        if (this.itemsSeen_ == 0L) {
            return null;
        }
        Class<?> clazz = this.data_.get(0).getClass();
        return this.data_.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public T[] getSamples(Class<?> clazz) {
        if (this.itemsSeen_ == 0L) {
            return null;
        }
        return this.data_.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public ArrayList<T> getRawSamplesAsList() {
        return this.data_;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append(Util.LS);
        sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   k            : ").append(this.reservoirSize_).append(Util.LS);
        sb.append("   n            : ").append(this.itemsSeen_).append(Util.LS);
        sb.append("   Current size : ").append(this.currItemsAlloc_).append(Util.LS);
        sb.append("   Resize factor: ").append((Object)this.rf_).append(Util.LS);
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<? super T> serDe) {
        if (this.itemsSeen_ == 0L) {
            return this.toByteArray(serDe, null);
        }
        return this.toByteArray(serDe, this.data_.get(0).getClass());
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<? super T> serDe, Class<?> clazz) {
        int outBytes;
        int preLongs;
        boolean empty = this.itemsSeen_ == 0L;
        byte[] bytes = null;
        if (empty) {
            preLongs = 1;
            outBytes = 8;
        } else {
            preLongs = Family.RESERVOIR.getMaxPreLongs();
            bytes = serDe.serializeToByteArray(this.getSamples(clazz));
            outBytes = (preLongs << 3) + bytes.length;
        }
        byte[] outArr = new byte[outBytes];
        NativeMemory mem = new NativeMemory(outArr);
        Object memObj = mem.array();
        long memAddr = mem.getCumulativeOffset(0L);
        PreambleUtil.insertPreLongs(memObj, memAddr, preLongs);
        PreambleUtil.insertLgResizeFactor(memObj, memAddr, this.rf_.lg());
        PreambleUtil.insertSerVer(memObj, memAddr, 2);
        PreambleUtil.insertFamilyID(memObj, memAddr, Family.RESERVOIR.getID());
        if (empty) {
            PreambleUtil.insertFlags(memObj, memAddr, 4);
        } else {
            PreambleUtil.insertFlags(memObj, memAddr, 0);
        }
        PreambleUtil.insertReservoirSize(memObj, memAddr, this.reservoirSize_);
        if (!empty) {
            PreambleUtil.insertItemsSeenCount(memObj, memAddr, this.itemsSeen_);
            int preBytes = preLongs << 3;
            mem.putByteArray(preBytes, bytes, 0, bytes.length);
        }
        return outArr;
    }

    double getImplicitSampleWeight() {
        if (this.itemsSeen_ < (long)this.reservoirSize_) {
            return 1.0;
        }
        return 1.0 * (double)this.itemsSeen_ / (double)this.reservoirSize_;
    }

    T getValueAtPosition(int pos) {
        if (this.itemsSeen_ == 0L) {
            throw new SketchesArgumentException("Requested element from empty reservoir.");
        }
        if (pos < 0 || pos >= this.getNumSamples()) {
            throw new SketchesArgumentException("Requested position must be between 0 and " + this.getNumSamples() + ", inclusive. Received: " + pos);
        }
        return this.data_.get(pos);
    }

    void insertValueAtPosition(T value, int pos) {
        if (pos < 0 || pos >= this.getNumSamples()) {
            throw new SketchesArgumentException("Insert position must be between 0 and " + this.getNumSamples() + ", inclusive. Received: " + pos);
        }
        this.data_.set(pos, value);
    }

    void forceIncrementItemsSeen(long inc) {
        this.itemsSeen_ += inc;
        if (this.itemsSeen_ > 0xFFFFFFFFFFFFL) {
            throw new SketchesStateException("Sketch has exceeded capacity for total items seen. Limit: 281474976710655, found: " + this.itemsSeen_);
        }
    }

    ReservoirItemsSketch<T> copy() {
        return new ReservoirItemsSketch<T>(this.reservoirSize_, this.currItemsAlloc_, this.itemsSeen_, this.rf_, (ArrayList)this.data_.clone());
    }

    ReservoirItemsSketch<T> downsampledCopy(int maxK) {
        ReservoirItemsSketch<T> ris = new ReservoirItemsSketch<T>(maxK, this.rf_);
        for (T item : this.getSamples()) {
            ris.update(item);
        }
        if (ris.getN() < this.itemsSeen_) {
            ris.forceIncrementItemsSeen(this.itemsSeen_ - ris.getN());
        }
        return ris;
    }

    private void growReservoir() {
        this.currItemsAlloc_ = SamplingUtil.getAdjustedSize(this.reservoirSize_, this.currItemsAlloc_ << this.rf_.lg());
        this.data_.ensureCapacity(this.currItemsAlloc_);
    }
}

