/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.Memory;
import com.alibaba.lindorm.thirdparty.com.yahoo.memory.MemoryUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.memory.NativeMemory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Family;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.HashOperations;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.ResizeFactor;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.SketchesArgumentException;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Util;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.PreambleUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.Rebuilder;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.UpdateReturnState;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.UpdateSketch;

final class DirectQuickSelectSketch
extends UpdateSketch {
    private static final double DQS_RESIZE_THRESHOLD = 0.9375;
    private final int lgNomLongs_;
    private final int preambleLongs_;
    private final long seed_;
    private final short seedHash_;
    private int hashTableThreshold_;
    private Memory mem_;

    private DirectQuickSelectSketch(int lgNomLongs, long seed, int preambleLongs) {
        this.lgNomLongs_ = Math.max(lgNomLongs, 4);
        this.seed_ = seed;
        this.seedHash_ = Util.computeSeedHash(this.seed_);
        this.preambleLongs_ = preambleLongs;
    }

    static DirectQuickSelectSketch initNewDirectInstance(int lgNomLongs, long seed, float p, ResizeFactor rf, Memory dstMem, boolean unionGadget) {
        Family family;
        int preambleLongs;
        if (unionGadget) {
            preambleLongs = Family.UNION.getMinPreLongs();
            family = Family.UNION;
        } else {
            preambleLongs = Family.QUICKSELECT.getMinPreLongs();
            family = Family.QUICKSELECT;
        }
        int lgRF = rf.lg();
        int lgArrLongs = lgRF == 0 ? lgNomLongs + 1 : 5;
        int minReqBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        long curMemCapBytes = dstMem.getCapacity();
        if (curMemCapBytes < (long)minReqBytes) {
            throw new SketchesArgumentException("Memory capacity is too small: " + curMemCapBytes + " < " + minReqBytes);
        }
        Object memObj = dstMem.array();
        long memAdd = dstMem.getCumulativeOffset(0L);
        PreambleUtil.insertPreLongs(memObj, memAdd, preambleLongs);
        PreambleUtil.insertLgResizeFactor(memObj, memAdd, lgRF);
        PreambleUtil.insertSerVer(memObj, memAdd, 3);
        PreambleUtil.insertFamilyID(memObj, memAdd, family.getID());
        PreambleUtil.insertLgNomLongs(memObj, memAdd, lgNomLongs);
        PreambleUtil.insertLgArrLongs(memObj, memAdd, lgArrLongs);
        PreambleUtil.insertFlags(memObj, memAdd, 4);
        PreambleUtil.insertSeedHash(memObj, memAdd, Util.computeSeedHash(seed));
        PreambleUtil.insertCurCount(memObj, memAdd, 0);
        PreambleUtil.insertP(memObj, memAdd, p);
        long thetaLong = (long)((double)p * 9.223372036854776E18);
        PreambleUtil.insertThetaLong(memObj, memAdd, thetaLong);
        dstMem.clear(preambleLongs << 3, 8 << lgArrLongs);
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(lgNomLongs, seed, preambleLongs);
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        dqss.mem_ = dstMem;
        return dqss;
    }

    static DirectQuickSelectSketch wrapInstance(Memory srcMem, long seed) {
        long thetaLong;
        float p;
        short seedHash;
        int flags;
        int lgArrLongs;
        int lgNomLongs;
        int familyID;
        int serVer;
        int preambleLongs;
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preambleLongs = srcMem.getByte(0L) & 0x3F;
            serVer = srcMem.getByte(1L) & 0xFF;
            familyID = srcMem.getByte(2L) & 0xFF;
            lgNomLongs = srcMem.getByte(3L) & 0xFF;
            lgArrLongs = srcMem.getByte(4L) & 0xFF;
            flags = srcMem.getByte(5L) & 0xFF;
            seedHash = srcMem.getShort(6L);
            p = srcMem.getFloat(12L);
            thetaLong = srcMem.getLong(16L);
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preambleLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            familyID = PreambleUtil.extractFamilyID(memObj, memAdd);
            lgNomLongs = PreambleUtil.extractLgNomLongs(memObj, memAdd);
            lgArrLongs = PreambleUtil.extractLgArrLongs(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            seedHash = (short)PreambleUtil.extractSeedHash(memObj, memAdd);
            p = PreambleUtil.extractP(memObj, memAdd);
            thetaLong = PreambleUtil.extractThetaLong(memObj, memAdd);
        }
        if (serVer != 3) {
            throw new SketchesArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
        }
        Family family = Family.idToFamily(familyID);
        if (family.equals((Object)Family.UNION)) {
            if (preambleLongs != Family.UNION.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for UNION: " + preambleLongs);
            }
        } else if (family.equals((Object)Family.QUICKSELECT)) {
            if (preambleLongs != Family.QUICKSELECT.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for QUICKSELECT: " + preambleLongs);
            }
        } else {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
        if (lgNomLongs < 4) {
            throw new SketchesArgumentException("Possible corruption: Current Memory lgNomLongs < min required size: " + lgNomLongs + " < " + 4);
        }
        int flagsMask = 27;
        if ((flags & 0x1B) > 0) {
            throw new SketchesArgumentException("Possible corruption: Input srcMem cannot be: big-endian, compact, ordered, or read-only");
        }
        Util.checkSeedHashes(seedHash, Util.computeSeedHash(seed));
        long curCapBytes = srcMem.getCapacity();
        int minReqBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        if (curCapBytes < (long)minReqBytes) {
            throw new SketchesArgumentException("Possible corruption: Current Memory size < min required size: " + curCapBytes + " < " + minReqBytes);
        }
        double theta = (double)thetaLong / 9.223372036854776E18;
        if (lgArrLongs <= lgNomLongs && theta < (double)p) {
            throw new SketchesArgumentException("Possible corruption: Theta cannot be < p and lgArrLongs <= lgNomLongs. " + lgArrLongs + " <= " + lgNomLongs + ", Theta: " + theta + ", p: " + p);
        }
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(lgNomLongs, seed, preambleLongs);
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        dqss.mem_ = srcMem;
        return dqss;
    }

    static DirectQuickSelectSketch fastWrap(Memory srcMem, long seed) {
        int lgArrLongs;
        int lgNomLongs;
        int preambleLongs;
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preambleLongs = srcMem.getByte(0L) & 0x3F;
            lgNomLongs = srcMem.getByte(3L) & 0xFF;
            lgArrLongs = srcMem.getByte(4L) & 0xFF;
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preambleLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            lgNomLongs = PreambleUtil.extractLgNomLongs(memObj, memAdd);
            lgArrLongs = PreambleUtil.extractLgArrLongs(memObj, memAdd);
        }
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(lgNomLongs, seed, preambleLongs);
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        dqss.mem_ = srcMem;
        return dqss;
    }

    @Override
    public Family getFamily() {
        int familyID = this.mem_.getByte(2L) & 0xFF;
        return Family.idToFamily(familyID);
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.getLgRF());
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.mem_.getInt(8L);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return (this.mem_.getByte(5L) & 4) > 0;
    }

    @Override
    public byte[] toByteArray() {
        byte lgArrLongs = this.mem_.getByte(4L);
        int lengthBytes = this.preambleLongs_ + (1 << lgArrLongs) << 3;
        byte[] byteArray = new byte[lengthBytes];
        NativeMemory mem = new NativeMemory(byteArray);
        this.mem_.copy(0L, mem, 0L, lengthBytes);
        return byteArray;
    }

    @Override
    public UpdateSketch rebuild() {
        if (this.getRetainedEntries(true) > 1 << this.getLgNomLongs()) {
            Rebuilder.quickSelectAndRebuild(this.mem_, this.preambleLongs_, this.lgNomLongs_);
        }
        return this;
    }

    @Override
    public final void reset() {
        int arrLongs = 1 << this.getLgArrLongs();
        int preBytes = this.preambleLongs_ << 3;
        this.mem_.clear(preBytes, arrLongs * 8);
        this.mem_.putByte(5L, (byte)4);
        this.mem_.putInt(8L, 0);
        float p = this.mem_.getFloat(12L);
        long thetaLong = (long)((double)p * 9.223372036854776E18);
        this.mem_.putLong(16L, thetaLong);
    }

    @Override
    int getPreambleLongs() {
        return this.preambleLongs_;
    }

    @Override
    long[] getCache() {
        long lgArrLongs = this.mem_.getByte(4L) & 0xFF;
        long[] cacheArr = new long[1 << (int)lgArrLongs];
        NativeMemory mem = new NativeMemory(cacheArr);
        this.mem_.copy(this.preambleLongs_ << 3, mem, 0L, 8 << (int)lgArrLongs);
        return cacheArr;
    }

    @Override
    int getLgNomLongs() {
        return this.lgNomLongs_;
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    float getP() {
        return this.mem_.getFloat(12L);
    }

    @Override
    long getSeed() {
        return this.seed_;
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    long getThetaLong() {
        return this.mem_.getLong(16L);
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    int getLgArrLongs() {
        return this.mem_.getByte(4L) & 0xFF;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        HashOperations.checkHashCorruption(hash);
        this.mem_.putByte(5L, (byte)(this.mem_.getByte(5L) & 0xFFFFFFFB));
        long thetaLong = this.getThetaLong();
        if (HashOperations.continueCondition(thetaLong, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        int lgArrLongs = this.getLgArrLongs();
        int index = this.mem_.isReadOnly() && !this.mem_.isDirect() ? HashOperations.hashSearchOrInsert(this.mem_, lgArrLongs, hash, this.preambleLongs_ << 3) : HashOperations.fastHashSearchOrInsert(this.mem_.array(), this.mem_.getCumulativeOffset(0L), lgArrLongs, hash, this.preambleLongs_ << 3);
        if (index >= 0) {
            return UpdateReturnState.RejectedDuplicate;
        }
        int curCount = this.getRetainedEntries() + 1;
        this.mem_.putInt(8L, curCount);
        if (curCount > this.hashTableThreshold_) {
            if (lgArrLongs > this.lgNomLongs_) {
                assert (lgArrLongs == this.lgNomLongs_ + 1) : "lgArr: " + lgArrLongs + ", lgNom: " + this.lgNomLongs_;
                Rebuilder.quickSelectAndRebuild(this.mem_, this.preambleLongs_, this.lgNomLongs_);
            } else {
                int lgRF = this.getLgRF();
                int actLgRF = Rebuilder.actLgResizeFactor(this.mem_.getCapacity(), lgArrLongs, this.preambleLongs_, lgRF);
                int tgtLgArrLongs = Math.min(lgArrLongs + actLgRF, this.lgNomLongs_ + 1);
                if (actLgRF > 0) {
                    Rebuilder.resize(this.mem_, this.preambleLongs_, lgArrLongs, tgtLgArrLongs);
                    this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, tgtLgArrLongs);
                } else {
                    int preBytes = this.preambleLongs_ << 3;
                    tgtLgArrLongs = Math.min(lgArrLongs + lgRF, this.lgNomLongs_ + 1);
                    int tgtArrBytes = 8 << tgtLgArrLongs;
                    int reqBytes = tgtArrBytes + preBytes;
                    Memory newDstMem = MemoryUtil.memoryRequestHandler(this.mem_, reqBytes, false);
                    Rebuilder.moveAndResize(this.mem_, this.preambleLongs_, lgArrLongs, newDstMem, tgtLgArrLongs, thetaLong);
                    this.mem_.getMemoryRequest().free(this.mem_, newDstMem);
                    this.mem_ = newDstMem;
                    this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, tgtLgArrLongs);
                }
            }
        }
        return UpdateReturnState.InsertedCountIncremented;
    }

    private int getLgRF() {
        return this.mem_.getByte(0L) >>> 6 & 3;
    }

    private static final int setHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.9375 : 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }
}

