/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.Memory;
import com.alibaba.lindorm.thirdparty.com.yahoo.memory.NativeMemory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Util;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.CompactSketch;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.PreambleUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.UpdateSketch;

final class HeapCompactOrderedSketch
extends CompactSketch {
    private final long[] cache_;

    private HeapCompactOrderedSketch(boolean empty, short seedHash, int curCount, long thetaLong, long[] cache) {
        super(empty, seedHash, curCount, thetaLong);
        this.cache_ = cache;
    }

    static HeapCompactOrderedSketch heapifyInstance(Memory srcMem, long seed) {
        long thetaLong;
        int curCount;
        short memSeedHash;
        int flags;
        int preLongs;
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preLongs = srcMem.getByte(0L) & 0x3F;
            flags = srcMem.getByte(5L) & 0xFF;
            memSeedHash = srcMem.getShort(6L);
            curCount = preLongs > 1 ? srcMem.getInt(8L) : 0;
            thetaLong = preLongs > 2 ? srcMem.getLong(16L) : Long.MAX_VALUE;
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            memSeedHash = (short)PreambleUtil.extractSeedHash(memObj, memAdd);
            curCount = preLongs > 1 ? PreambleUtil.extractCurCount(memObj, memAdd) : 0;
            thetaLong = preLongs > 2 ? PreambleUtil.extractThetaLong(memObj, memAdd) : Long.MAX_VALUE;
        }
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        boolean empty = (flags & 4) > 0;
        long[] cacheArr = new long[curCount];
        if (curCount > 0) {
            srcMem.getLongArray(preLongs << 3, cacheArr, 0, curCount);
        }
        HeapCompactOrderedSketch hcs = new HeapCompactOrderedSketch(empty, memSeedHash, curCount, thetaLong, cacheArr);
        return hcs;
    }

    HeapCompactOrderedSketch(UpdateSketch sketch) {
        super(sketch.isEmpty(), sketch.getSeedHash(), sketch.getRetainedEntries(true), sketch.getThetaLong());
        boolean ordered = true;
        this.cache_ = CompactSketch.compactCache(sketch.getCache(), this.getRetainedEntries(false), this.getThetaLong(), true);
    }

    HeapCompactOrderedSketch(long[] compactOrderedCache, boolean empty, short seedHash, int curCount, long thetaLong) {
        super(empty, seedHash, curCount, thetaLong);
        assert (compactOrderedCache != null);
        this.cache_ = curCount == 0 ? new long[]{} : compactOrderedCache;
    }

    @Override
    public byte[] toByteArray() {
        byte[] byteArray = new byte[this.getCurrentBytes(true)];
        NativeMemory dstMem = new NativeMemory(byteArray);
        int emptyBit = this.isEmpty() ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | 0x10);
        HeapCompactOrderedSketch.loadCompactMemory(this.getCache(), this.isEmpty(), this.getSeedHash(), this.getRetainedEntries(true), this.getThetaLong(), dstMem, flags);
        return byteArray;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

