/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.Memory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.HashOperations;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.QuickSelect;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Util;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.PreambleUtil;

final class Rebuilder {
    private Rebuilder() {
    }

    static final void quickSelectAndRebuild(Memory mem, int preambleLongs, int lgNomLongs) {
        Object memObj = mem.array();
        long memAdd = mem.getCumulativeOffset(0L);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(memObj, memAdd);
        int curCount = PreambleUtil.extractCurCount(memObj, memAdd);
        int arrLongs = 1 << lgArrLongs;
        long[] tmpArr = new long[arrLongs];
        int preBytes = preambleLongs << 3;
        mem.getLongArray(preBytes, tmpArr, 0, arrLongs);
        int pivot = (1 << lgNomLongs) + 1;
        long newThetaLong = QuickSelect.selectExcludingZeros(tmpArr, curCount, pivot);
        PreambleUtil.insertThetaLong(memObj, memAdd, newThetaLong);
        long[] tgtArr = new long[arrLongs];
        int newCurCount = HashOperations.hashArrayInsert(tmpArr, tgtArr, lgArrLongs, newThetaLong);
        PreambleUtil.insertCurCount(memObj, memAdd, newCurCount);
        mem.putLongArray(preBytes, tgtArr, 0, arrLongs);
    }

    static final void moveAndResize(Memory srcMem, int preambleLongs, int srcLgArrLongs, Memory dstMem, int dstLgArrLongs, long thetaLong) {
        int preBytes = preambleLongs << 3;
        srcMem.copy(0L, dstMem, 0L, preBytes);
        int srcHTLen = 1 << srcLgArrLongs;
        long[] srcHTArr = new long[srcHTLen];
        srcMem.getLongArray(preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << dstLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, dstLgArrLongs, thetaLong);
        dstMem.putLongArray(preBytes, dstHTArr, 0, dstHTLen);
        dstMem.putByte(4L, (byte)dstLgArrLongs);
    }

    static final void resize(Memory mem, int preambleLongs, int srcLgArrLongs, int tgtLgArrLongs) {
        Object memObj = mem.array();
        long memAdd = mem.getCumulativeOffset(0L);
        int preBytes = preambleLongs << 3;
        int srcHTLen = 1 << srcLgArrLongs;
        long[] srcHTArr = new long[srcHTLen];
        mem.getLongArray(preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << tgtLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        long thetaLong = PreambleUtil.extractThetaLong(memObj, memAdd);
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, tgtLgArrLongs, thetaLong);
        mem.putLongArray(preBytes, dstHTArr, 0, dstHTLen);
        PreambleUtil.insertLgArrLongs(memObj, memAdd, tgtLgArrLongs);
    }

    static final int actLgResizeFactor(long capBytes, int lgArrLongs, int preLongs, int lgRF) {
        int maxHTLongs = Util.floorPowerOf2((int)(capBytes >> 3) - preLongs);
        int lgFactor = Math.max(Integer.numberOfTrailingZeros(maxHTLongs) - lgArrLongs, 0);
        return lgFactor >= lgRF ? lgRF : lgFactor;
    }
}

