/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.netty.jctools.queues;

import com.alibaba.lindorm.thirdparty.netty.jctools.queues.MpscArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.MpscCompoundQueueL0Pad;
import com.alibaba.lindorm.thirdparty.netty.jctools.util.Pow2;

abstract class MpscCompoundQueueColdFields<E>
extends MpscCompoundQueueL0Pad<E> {
    protected final int parallelQueues;
    protected final int parallelQueuesMask;
    protected final MpscArrayQueue<E>[] queues;

    public MpscCompoundQueueColdFields(int capacity, int queueParallelism) {
        this.parallelQueues = Pow2.isPowerOfTwo(queueParallelism) ? queueParallelism : Pow2.roundToPowerOfTwo(queueParallelism) / 2;
        this.parallelQueuesMask = this.parallelQueues - 1;
        this.queues = new MpscArrayQueue[this.parallelQueues];
        int fullCapacity = Pow2.roundToPowerOfTwo(capacity);
        if (fullCapacity < this.parallelQueues) {
            throw new IllegalArgumentException("Queue capacity must exceed parallelism");
        }
        for (int i = 0; i < this.parallelQueues; ++i) {
            this.queues[i] = new MpscArrayQueue(fullCapacity / this.parallelQueues);
        }
    }
}

