/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.AbstractElasticsearchTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.ElasticsearchToEnumerableConverterRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCost;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.TableScan;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import java.util.List;

public class ElasticsearchTableScan
extends TableScan
implements ElasticsearchRel {
    private final AbstractElasticsearchTable elasticsearchTable;
    private final RelDataType projectRowType;

    protected ElasticsearchTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, AbstractElasticsearchTable elasticsearchTable, RelDataType projectRowType) {
        super(cluster, traitSet, table);
        this.elasticsearchTable = Preconditions.checkNotNull(elasticsearchTable);
        this.projectRowType = projectRowType;
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        float f = this.projectRowType == null ? 1.0f : (float)this.projectRowType.getFieldCount() / 100.0f;
        return super.computeSelfCost(planner, mq).multiplyBy(0.1 * (double)f);
    }

    @Override
    public void register(RelOptPlanner planner) {
        planner.addRule(ElasticsearchToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : ElasticsearchRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.elasticsearchTable = this.elasticsearchTable;
        implementor.table = this.table;
    }
}

