/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Function;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Lists;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.AbstractElasticsearchTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.ElasticsearchMethod;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.PhysType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expressions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.MethodCallExpression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.ConventionTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCost;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.CalcitePrepareImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.convert.ConverterImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.Hook;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BuiltInMethod;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;
import javax.annotation.Nullable;

public class ElasticsearchToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected ElasticsearchToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, traits, input);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ElasticsearchToEnumerableConverter(this.getCluster(), traitSet, ElasticsearchToEnumerableConverter.sole(inputs));
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer prefer) {
        BlockBuilder list = new BlockBuilder();
        ElasticsearchRel.Implementor elasticsearchImplementor = new ElasticsearchRel.Implementor();
        elasticsearchImplementor.visitChild(0, this.getInput());
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), rowType, prefer.prefer(JavaRowFormat.ARRAY));
        Expression fields = list.append("fields", ElasticsearchToEnumerableConverter.constantArrayList(Pair.zip(ElasticsearchRules.elasticsearchFieldNames(rowType), new AbstractList<Class>(){

            @Override
            public Class get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }), Pair.class));
        Expression table = list.append("table", elasticsearchImplementor.table.getExpression(AbstractElasticsearchTable.ElasticsearchQueryable.class));
        List<String> opList = elasticsearchImplementor.list;
        Expression ops = list.append("ops", ElasticsearchToEnumerableConverter.constantArrayList(opList, String.class));
        Expression enumerable = list.append("enumerable", Expressions.call(table, ElasticsearchMethod.ELASTICSEARCH_QUERYABLE_FIND.method, ops, fields));
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println("Elasticsearch: " + opList);
        }
        Hook.QUERY_PLAN.run(opList);
        list.add(Expressions.return_(null, enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class clazz) {
        return Expressions.call(BuiltInMethod.ARRAYS_AS_LIST.method, Expressions.newArrayInit((Type)clazz, ElasticsearchToEnumerableConverter.constantList(values)));
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return Lists.transform(values, new Function<T, Expression>(){

            @Override
            @Nullable
            public Expression apply(@Nullable T t) {
                return Expressions.constant(t);
            }
        });
    }
}

