/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsontype.impl;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.core.JsonParser;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.core.JsonToken;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.core.util.JsonParserSequence;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.BeanProperty;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.DeserializationContext;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JavaType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JsonDeserializer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;

public class AsArrayTypeDeserializer
extends TypeDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 1L;

    public AsArrayTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, Class<?> defaultImpl) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    public AsArrayTypeDeserializer(AsArrayTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsArrayTypeDeserializer(this, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_ARRAY;
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    protected Object _deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (p.canReadTypeId() && (typeId = p.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(p, ctxt, typeId);
        }
        boolean hadStartArray = p.isExpectedStartArrayToken();
        String typeId2 = this._locateTypeId(p, ctxt);
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, typeId2);
        if (this._typeIdVisible && !this._usesExternalId() && p.getCurrentToken() == JsonToken.START_OBJECT) {
            TokenBuffer tb = new TokenBuffer(null, false);
            tb.writeStartObject();
            tb.writeFieldName(this._typePropertyName);
            tb.writeString(typeId2);
            p = JsonParserSequence.createFlattened(tb.asParser(p), p);
            p.nextToken();
        }
        Object value = deser.deserialize(p, ctxt);
        if (hadStartArray && p.nextToken() != JsonToken.END_ARRAY) {
            throw ctxt.wrongTokenException(p, JsonToken.END_ARRAY, "expected closing END_ARRAY after type information and deserialized value");
        }
        return value;
    }

    protected String _locateTypeId(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (!jp.isExpectedStartArrayToken()) {
            if (this._defaultImpl != null) {
                return this._idResolver.idFromBaseType();
            }
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "need JSON Array to contain As.WRAPPER_ARRAY type information for class " + this.baseTypeName());
        }
        JsonToken t = jp.nextToken();
        if (t == JsonToken.VALUE_STRING) {
            String result = jp.getText();
            jp.nextToken();
            return result;
        }
        if (this._defaultImpl != null) {
            return this._idResolver.idFromBaseType();
        }
        throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "need JSON String that contains type id (for subtype of " + this.baseTypeName() + ")");
    }

    protected boolean _usesExternalId() {
        return false;
    }
}

