/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.ser.impl;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.core.JsonGenerationException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.core.JsonGenerator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.BeanProperty;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JsonMappingException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JsonNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JsonSerializer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.SerializationFeature;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.SerializerProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;
import java.io.IOException;
import java.util.Collection;

@JacksonStdImpl
public class StringCollectionSerializer
extends StaticListSerializerBase<Collection<String>> {
    public static final StringCollectionSerializer instance = new StringCollectionSerializer();

    protected StringCollectionSerializer() {
        super(Collection.class);
    }

    protected StringCollectionSerializer(StringCollectionSerializer src, JsonSerializer<?> ser, Boolean unwrapSingle) {
        super(src, ser, unwrapSingle);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, JsonSerializer<?> ser, Boolean unwrapSingle) {
        return new StringCollectionSerializer(this, ser, unwrapSingle);
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) throws JsonMappingException {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(Collection<String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this._serializeUnwrapped(value, gen, provider);
            return;
        }
        gen.writeStartArray(len);
        if (this._serializer == null) {
            this.serializeContents(value, gen, provider);
        } else {
            this.serializeUsingCustom(value, gen, provider);
        }
        gen.writeEndArray();
    }

    private final void _serializeUnwrapped(Collection<String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._serializer == null) {
            this.serializeContents(value, gen, provider);
        } else {
            this.serializeUsingCustom(value, gen, provider);
        }
    }

    @Override
    public void serializeWithType(Collection<String> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForArray(value, jgen);
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider);
        } else {
            this.serializeUsingCustom(value, jgen, provider);
        }
        typeSer.writeTypeSuffixForArray(value, jgen);
    }

    private final void serializeContents(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._serializer != null) {
            this.serializeUsingCustom(value, jgen, provider);
            return;
        }
        int i = 0;
        for (String str : value) {
            try {
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                } else {
                    jgen.writeString(str);
                }
                ++i;
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }
    }

    private void serializeUsingCustom(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        JsonSerializer ser = this._serializer;
        int i = 0;
        for (String str : value) {
            try {
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                ser.serialize(str, jgen, provider);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }
    }
}

