/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.AvaticaUtils;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class AvaticaHttpClientImpl
implements AvaticaHttpClient {
    protected final URL url;

    public AvaticaHttpClientImpl(URL url) {
        this.url = url;
    }

    @Override
    public byte[] send(byte[] request) {
        try {
            HttpURLConnection connection;
            int responseCode;
            do {
                connection = this.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                    wr.write(request);
                    wr.flush();
                    wr.close();
                }
            } while ((responseCode = connection.getResponseCode()) == 503);
            InputStream inputStream = responseCode != 200 ? connection.getErrorStream() : connection.getInputStream();
            return AvaticaUtils.readFullyToBytes(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    HttpURLConnection openConnection() throws IOException {
        return (HttpURLConnection)this.url.openConnection();
    }
}

