/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.AvaticaUtils;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.MetricsSystem;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.Timer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.Handler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.JsonHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.MetricsHelper;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.Service;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AbstractAvaticaHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.RemoteUserDisallowedException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.RemoteUserExtractionException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.Request;
import com.alibaba.lindorm.thirdparty.org.slf4j.Logger;
import com.alibaba.lindorm.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AvaticaJsonHandler
extends AbstractAvaticaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaJsonHandler.class);
    final Service service;
    final JsonHandler jsonHandler;
    final MetricsSystem metrics;
    final Timer requestTimer;
    final ThreadLocal<UnsynchronizedBuffer> threadLocalBuffer;
    final AvaticaServerConfiguration serverConfig;

    public AvaticaJsonHandler(Service service) {
        this(service, NoopMetricsSystem.getInstance(), null);
    }

    public AvaticaJsonHandler(Service service, MetricsSystem metrics) {
        this(service, metrics, null);
    }

    public AvaticaJsonHandler(Service service, MetricsSystem metrics, AvaticaServerConfiguration serverConfig) {
        this.service = Objects.requireNonNull(service);
        this.metrics = Objects.requireNonNull(metrics);
        this.jsonHandler = new JsonHandler(service, this.metrics);
        this.requestTimer = this.metrics.getTimer(MetricsHelper.concat(AvaticaJsonHandler.class, "Handler.RequestTimings"));
        this.threadLocalBuffer = new ThreadLocal<UnsynchronizedBuffer>(){

            @Override
            public UnsynchronizedBuffer initialValue() {
                return new UnsynchronizedBuffer();
            }
        };
        this.serverConfig = serverConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block38: {
            try (Timer.Context ctx = this.requestTimer.start();){
                Handler.HandlerResponse<String> jsonResponse;
                if (!this.isUserPermitted(this.serverConfig, request, response)) {
                    LOG.debug("HTTP request from {} is unauthenticated and authentication is required", (Object)request.getRemoteAddr());
                    return;
                }
                response.setContentType("application/json;charset=utf-8");
                response.setStatus(200);
                if (!request.getMethod().equals("POST")) break block38;
                String rawRequest = request.getHeader("request");
                if (rawRequest == null) {
                    UnsynchronizedBuffer buffer = this.threadLocalBuffer.get();
                    try (ServletInputStream inputStream = request.getInputStream();){
                        rawRequest = AvaticaUtils.readFully((InputStream)inputStream, buffer);
                    }
                    finally {
                        buffer.reset();
                    }
                }
                final String jsonRequest = new String(rawRequest.getBytes("ISO-8859-1"), "UTF-8");
                LOG.trace("request: {}", (Object)jsonRequest);
                try {
                    if (null != this.serverConfig && this.serverConfig.supportsImpersonation()) {
                        String remoteUser = this.serverConfig.getRemoteUserExtractor().extract(request);
                        jsonResponse = this.serverConfig.doAsRemoteUser(remoteUser, request.getRemoteAddr(), new Callable<Handler.HandlerResponse<String>>(){

                            @Override
                            public Handler.HandlerResponse<String> call() {
                                return AvaticaJsonHandler.this.jsonHandler.apply(jsonRequest);
                            }
                        });
                    } else {
                        jsonResponse = this.jsonHandler.apply(jsonRequest);
                    }
                }
                catch (RemoteUserExtractionException e) {
                    LOG.debug("Failed to extract remote user from request", e);
                    jsonResponse = this.jsonHandler.unauthenticatedErrorResponse(e);
                }
                catch (RemoteUserDisallowedException e) {
                    LOG.debug("Remote user is not authorized", e);
                    jsonResponse = this.jsonHandler.unauthorizedErrorResponse(e);
                }
                catch (Exception e) {
                    LOG.debug("Error invoking request from {}", (Object)baseRequest.getRemoteAddr(), (Object)e);
                    jsonResponse = this.jsonHandler.convertToErrorResponse(e);
                }
                LOG.trace("response: {}", (Object)jsonResponse);
                baseRequest.setHandled(true);
                response.setStatus(jsonResponse.getStatusCode());
                response.getWriter().println(jsonResponse.getResponse());
            }
        }
    }

    @Override
    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        this.service.setRpcMetadata(metadata);
        this.jsonHandler.setRpcMetadata(metadata);
    }

    @Override
    public MetricsSystem getMetrics() {
        return this.metrics;
    }
}

