/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

public class Ord<E>
implements Map.Entry<Integer, E> {
    public final int i;
    public final E e;

    public Ord(int i, E e) {
        this.i = i;
        this.e = e;
    }

    public static <E> Ord<E> of(int n, E e) {
        return new Ord<E>(n, e);
    }

    public static <E> Iterable<Ord<E>> zip(final Iterable<? extends E> iterable) {
        return new Iterable<Ord<E>>(){

            @Override
            public Iterator<Ord<E>> iterator() {
                return Ord.zip(iterable.iterator());
            }
        };
    }

    public static <E> Iterator<Ord<E>> zip(final Iterator<? extends E> iterator) {
        return new Iterator<Ord<E>>(){
            int n = 0;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Ord<E> next() {
                return Ord.of(this.n++, iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <E> List<Ord<E>> zip(E[] elements) {
        return new OrdArrayList<E>(elements);
    }

    public static <E> List<Ord<E>> zip(List<? extends E> elements) {
        return elements instanceof RandomAccess ? new OrdRandomAccessList<E>(elements) : new OrdList<E>(elements);
    }

    public static <E> Iterable<Ord<E>> reverse(E ... elements) {
        return Ord.reverse(ImmutableList.copyOf(elements));
    }

    public static <E> Iterable<Ord<E>> reverse(Iterable<? extends E> elements) {
        final ImmutableList<? extends E> elementList = ImmutableList.copyOf(elements);
        return new Iterable<Ord<E>>(){

            @Override
            public Iterator<Ord<E>> iterator() {
                return new Iterator<Ord<E>>(){
                    int i;
                    {
                        this.i = elementList.size() - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i >= 0;
                    }

                    @Override
                    public Ord<E> next() {
                        return Ord.of(this.i, elementList.get(this.i--));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    @Override
    public Integer getKey() {
        return this.i;
    }

    @Override
    public E getValue() {
        return this.e;
    }

    @Override
    public E setValue(E value) {
        throw new UnsupportedOperationException();
    }

    private static class OrdArrayList<E>
    extends AbstractList<Ord<E>>
    implements RandomAccess {
        private final E[] elements;

        OrdArrayList(E[] elements) {
            this.elements = elements;
        }

        @Override
        public Ord<E> get(int index) {
            return Ord.of(index, this.elements[index]);
        }

        @Override
        public int size() {
            return this.elements.length;
        }
    }

    private static class OrdRandomAccessList<E>
    extends OrdList<E>
    implements RandomAccess {
        OrdRandomAccessList(List<? extends E> elements) {
            super(elements);
        }
    }

    private static class OrdList<E>
    extends AbstractList<Ord<E>> {
        private final List<? extends E> elements;

        OrdList(List<? extends E> elements) {
            this.elements = elements;
        }

        @Override
        public Ord<E> get(int index) {
            return Ord.of(index, this.elements.get(index));
        }

        @Override
        public int size() {
            return this.elements.size();
        }
    }
}

