/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Supplier;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Suppliers;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Enumerable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.function.Function1;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize.Lattice;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize.LatticeStatisticProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize.MaterializationService;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.profile.Profiler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.profile.ProfilerImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.NullSentinel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ScannableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Table;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ProfilerLatticeStatisticProvider
implements LatticeStatisticProvider {
    static final LatticeStatisticProvider.Factory FACTORY = new LatticeStatisticProvider.Factory(){

        @Override
        public LatticeStatisticProvider apply(Lattice lattice) {
            return new ProfilerLatticeStatisticProvider(lattice);
        }
    };
    private static final Function1<Object[], List<Comparable>> TO_LIST = new Function1<Object[], List<Comparable>>(){

        @Override
        public List<Comparable> apply(Object[] values) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                values[i] = NullSentinel.INSTANCE;
            }
            return Arrays.asList(values);
        }
    };
    private final Lattice lattice;
    private final Supplier<Profiler.Profile> profile = Suppliers.memoize(new Supplier<Profiler.Profile>(){

        @Override
        public Profiler.Profile get() {
            ProfilerImpl profiler = ProfilerImpl.builder().withPassSize(200).withMinimumSurprise(0.3).build();
            ArrayList<Profiler.Column> columns = new ArrayList<Profiler.Column>();
            for (Lattice.Column column : ((ProfilerLatticeStatisticProvider)ProfilerLatticeStatisticProvider.this).lattice.columns) {
                columns.add(new Profiler.Column(column.ordinal, column.alias));
            }
            String sql = ProfilerLatticeStatisticProvider.this.lattice.sql(ImmutableBitSet.range(((ProfilerLatticeStatisticProvider)ProfilerLatticeStatisticProvider.this).lattice.columns.size()), false, ImmutableList.of());
            Table table = new MaterializationService.DefaultTableFactory().createTable(((ProfilerLatticeStatisticProvider)ProfilerLatticeStatisticProvider.this).lattice.rootSchema, sql, ImmutableList.of());
            ImmutableList<ImmutableBitSet> initialGroups = ImmutableList.of();
            Enumerable<List<Comparable>> rows = ((ScannableTable)table).scan(null).select(TO_LIST);
            return profiler.profile(rows, columns, initialGroups);
        }
    });

    private ProfilerLatticeStatisticProvider(Lattice lattice) {
        this.lattice = Preconditions.checkNotNull(lattice);
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ImmutableBitSet build = Lattice.Column.toBitSet(columns);
        double cardinality = this.profile.get().cardinality(build);
        return cardinality;
    }
}

