/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rules;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Function;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableCollection;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Lists;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRuleCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRuleOperand;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.SubstitutionVisitor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Aggregate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.AggregateCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Filter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.RelFactories;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlAggFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.RelBuilderFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableBitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.mapping.Mappings;
import java.util.ArrayList;
import java.util.List;

public class AggregateFilterTransposeRule
extends RelOptRule {
    public static final AggregateFilterTransposeRule INSTANCE = new AggregateFilterTransposeRule();

    private AggregateFilterTransposeRule() {
        this(AggregateFilterTransposeRule.operand(Aggregate.class, AggregateFilterTransposeRule.operand(Filter.class, AggregateFilterTransposeRule.any()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER);
    }

    public AggregateFilterTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory) {
        super(operand, relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Filter filter = (Filter)call.rel(1);
        ImmutableBitSet filterColumns = RelOptUtil.InputFinder.bits(filter.getCondition());
        final ImmutableBitSet newGroupSet = aggregate.getGroupSet().union(filterColumns);
        RelNode input = filter.getInput();
        RelMetadataQuery mq = call.getMetadataQuery();
        Boolean unique = mq.areColumnsUnique(input, newGroupSet);
        if (unique != null && unique.booleanValue()) {
            return;
        }
        boolean allColumnsInAggregate = aggregate.getGroupSet().contains(filterColumns);
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), input, false, newGroupSet, null, aggregate.getAggCallList());
        Mappings.TargetMapping mapping = Mappings.target(new Function<Integer, Integer>(){

            @Override
            public Integer apply(Integer a0) {
                return newGroupSet.indexOf(a0);
            }
        }, input.getRowType().getFieldCount(), newGroupSet.cardinality());
        RexNode newCondition = RexUtil.apply(mapping, filter.getCondition());
        Filter newFilter = filter.copy(filter.getTraitSet(), newAggregate, newCondition);
        if (allColumnsInAggregate && aggregate.getGroupType() == Aggregate.Group.SIMPLE) {
            assert (newGroupSet.equals(aggregate.getGroupSet()));
            call.transformTo(newFilter);
        } else {
            ImmutableBitSet.Builder topGroupSet = ImmutableBitSet.builder();
            for (int c : aggregate.getGroupSet()) {
                topGroupSet.set(newGroupSet.indexOf(c));
            }
            ImmutableCollection newGroupingSets = null;
            if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
                ImmutableList.Builder newGroupingSetsBuilder = ImmutableList.builder();
                for (ImmutableBitSet immutableBitSet : aggregate.getGroupSets()) {
                    ImmutableBitSet.Builder newGroupingSet = ImmutableBitSet.builder();
                    for (int c : immutableBitSet) {
                        newGroupingSet.set(newGroupSet.indexOf(c));
                    }
                    newGroupingSetsBuilder.add(newGroupingSet.build());
                }
                newGroupingSets = newGroupingSetsBuilder.build();
            }
            ArrayList<AggregateCall> topAggCallList = Lists.newArrayList();
            int i = newGroupSet.cardinality();
            for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                SqlAggFunction rollup = SubstitutionVisitor.getRollup(aggregateCall.getAggregation());
                if (rollup == null) {
                    return;
                }
                if (aggregateCall.isDistinct()) {
                    return;
                }
                topAggCallList.add(AggregateCall.create(rollup, aggregateCall.isDistinct(), aggregateCall.isApproximate(), ImmutableList.of(Integer.valueOf(i++)), -1, aggregateCall.type, aggregateCall.name));
            }
            Aggregate aggregate2 = aggregate.copy(aggregate.getTraitSet(), newFilter, aggregate.indicator, topGroupSet.build(), (List<ImmutableBitSet>)((Object)newGroupingSets), topAggCallList);
            call.transformTo(aggregate2);
        }
    }
}

