/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rules;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRuleCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Intersect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.RelFactories;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalIntersect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.RelBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.RelBuilderFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableBitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.math.BigDecimal;

public class IntersectToDistinctRule
extends RelOptRule {
    public static final IntersectToDistinctRule INSTANCE = new IntersectToDistinctRule(LogicalIntersect.class, RelFactories.LOGICAL_BUILDER);

    public IntersectToDistinctRule(Class<? extends Intersect> intersectClazz, RelBuilderFactory relBuilderFactory) {
        super(IntersectToDistinctRule.operand(intersectClazz, IntersectToDistinctRule.any()), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Intersect intersect = (Intersect)call.rel(0);
        if (intersect.all) {
            return;
        }
        RelOptCluster cluster = intersect.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelBuilder relBuilder = call.builder();
        for (RelNode input : intersect.getInputs()) {
            relBuilder.push(input);
            relBuilder.aggregate(relBuilder.groupKey(relBuilder.fields()), relBuilder.countStar(null));
        }
        int branchCount = intersect.getInputs().size();
        relBuilder.union(true, branchCount);
        RelNode union = relBuilder.peek();
        int fieldCount = union.getRowType().getFieldCount();
        ImmutableBitSet groupSet = ImmutableBitSet.range(fieldCount - 1);
        relBuilder.aggregate(relBuilder.groupKey(groupSet, null), relBuilder.countStar(null));
        relBuilder.filter(relBuilder.equals(relBuilder.field(fieldCount - 1), rexBuilder.makeBigintLiteral(new BigDecimal(branchCount))));
        relBuilder.project(Util.skipLast(relBuilder.fields()));
        call.transformTo(relBuilder.build());
    }
}

