/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rex;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexInputRef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexShuttle;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.mapping.Mappings;
import java.util.List;

public class RexPermuteInputsShuttle
extends RexShuttle {
    private final Mappings.TargetMapping mapping;
    private final ImmutableList<RelDataTypeField> fields;

    public RexPermuteInputsShuttle(Mappings.TargetMapping mapping, RelNode ... inputs) {
        this(mapping, RexPermuteInputsShuttle.fields(inputs));
    }

    private RexPermuteInputsShuttle(Mappings.TargetMapping mapping, ImmutableList<RelDataTypeField> fields) {
        this.mapping = mapping;
        this.fields = fields;
    }

    public static RexPermuteInputsShuttle of(Mappings.TargetMapping mapping) {
        return new RexPermuteInputsShuttle(mapping, ImmutableList.of());
    }

    private static ImmutableList<RelDataTypeField> fields(RelNode[] inputs) {
        ImmutableList.Builder fields = ImmutableList.builder();
        for (RelNode input : inputs) {
            fields.addAll(input.getRowType().getFieldList());
        }
        return fields.build();
    }

    @Override
    public RexNode visitInputRef(RexInputRef local) {
        int index = local.getIndex();
        int target = this.mapping.getTarget(index);
        return new RexInputRef(target, local.getType());
    }

    @Override
    public RexNode visitCall(RexCall call) {
        String name;
        int i;
        if (call.getOperator() == RexBuilder.GET_OPERATOR && (i = RexPermuteInputsShuttle.lookup(this.fields, name = (String)((RexLiteral)call.getOperands().get(1)).getValue2())) >= 0) {
            return RexInputRef.of(i, this.fields);
        }
        return super.visitCall(call);
    }

    private static int lookup(List<RelDataTypeField> fields, String name) {
        for (int i = 0; i < fields.size(); ++i) {
            RelDataTypeField field = fields.get(i);
            if (!field.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

