/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rex;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexBiVisitor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexVisitor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlQuantifyOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import java.util.List;

public class RexSubQuery
extends RexCall {
    public final RelNode rel;

    private RexSubQuery(RelDataType type, SqlOperator op, ImmutableList<RexNode> operands, RelNode rel) {
        super(type, op, operands);
        this.rel = rel;
        this.digest = this.computeDigest(false);
    }

    public static RexSubQuery in(RelNode rel, ImmutableList<RexNode> nodes) {
        RelDataType type = RexSubQuery.type(rel, nodes);
        return new RexSubQuery(type, SqlStdOperatorTable.IN, nodes, rel);
    }

    public static RexSubQuery some(RelNode rel, ImmutableList<RexNode> nodes, SqlQuantifyOperator op) {
        assert (op.kind == SqlKind.SOME);
        RelDataType type = RexSubQuery.type(rel, nodes);
        return new RexSubQuery(type, op, nodes, rel);
    }

    static RelDataType type(RelNode rel, ImmutableList<RexNode> nodes) {
        assert (rel.getRowType().getFieldCount() == nodes.size());
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        boolean nullable = false;
        for (RexNode node : nodes) {
            if (!node.getType().isNullable()) continue;
            nullable = true;
        }
        for (RelDataTypeField field : rel.getRowType().getFieldList()) {
            if (!field.getType().isNullable()) continue;
            nullable = true;
        }
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), nullable);
    }

    public static RexSubQuery exists(RelNode rel) {
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType type = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        return new RexSubQuery(type, SqlStdOperatorTable.EXISTS, ImmutableList.of(), rel);
    }

    public static RexSubQuery scalar(RelNode rel) {
        List<RelDataTypeField> fieldList = rel.getRowType().getFieldList();
        assert (fieldList.size() == 1);
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType type = typeFactory.createTypeWithNullability(fieldList.get(0).getType(), true);
        return new RexSubQuery(type, SqlStdOperatorTable.SCALAR_QUERY, ImmutableList.of(), rel);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitSubQuery(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitSubQuery(this, arg);
    }

    @Override
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        sb.append("(");
        for (RexNode operand : this.operands) {
            sb.append(operand.toString());
            sb.append(", ");
        }
        sb.append("{\n");
        sb.append(RelOptUtil.toString(this.rel));
        sb.append("})");
        return sb.toString();
    }

    @Override
    public RexSubQuery clone(RelDataType type, List<RexNode> operands) {
        return new RexSubQuery(type, this.getOperator(), ImmutableList.copyOf(operands), this.rel);
    }

    public RexSubQuery clone(RelNode rel) {
        return new RexSubQuery(this.type, this.getOperator(), this.operands, rel);
    }
}

