/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteConnection;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize.MaterializationKey;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize.MaterializationService;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelProtoDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Schemas;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Table;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.TranslatableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTableMacro;
import java.lang.reflect.Type;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;

public class MaterializedViewTable
extends ViewTable {
    private final MaterializationKey key;
    public static final CalciteConnection MATERIALIZATION_CONNECTION;

    public MaterializedViewTable(Type elementType, RelProtoDataType relDataType, String viewSql, List<String> viewSchemaPath, List<String> viewPath, MaterializationKey key) {
        super(elementType, relDataType, viewSql, viewSchemaPath, viewPath);
        this.key = key;
    }

    public static MaterializedViewTableMacro create(CalciteSchema schema, String viewSql, List<String> viewSchemaPath, List<String> viewPath, String suggestedTableName, boolean existing) {
        return new MaterializedViewTableMacro(schema, viewSql, viewSchemaPath, viewPath, suggestedTableName, existing);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        Table materializeTable;
        CalciteSchema.TableEntry tableEntry = MaterializationService.instance().checkValid(this.key);
        if (tableEntry != null && (materializeTable = tableEntry.getTable()) instanceof TranslatableTable) {
            TranslatableTable table = (TranslatableTable)materializeTable;
            return table.toRel(context, relOptTable);
        }
        return super.toRel(context, relOptTable);
    }

    static {
        try {
            MATERIALIZATION_CONNECTION = DriverManager.getConnection("jdbc:calcite:").unwrap(CalciteConnection.class);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MaterializedViewTableMacro
    extends ViewTableMacro {
        private final MaterializationKey key;

        private MaterializedViewTableMacro(CalciteSchema schema, String viewSql, List<String> viewSchemaPath, List<String> viewPath, String suggestedTableName, boolean existing) {
            super(schema, viewSql, viewSchemaPath != null ? viewSchemaPath : schema.path(null), viewPath, Boolean.TRUE);
            this.key = Preconditions.checkNotNull(MaterializationService.instance().defineMaterialization(schema, null, viewSql, this.schemaPath, suggestedTableName, true, existing));
        }

        @Override
        public TranslatableTable apply(List<Object> arguments) {
            assert (arguments.isEmpty());
            CalcitePrepare.ParseResult parsed = Schemas.parse(MATERIALIZATION_CONNECTION, this.schema, this.schemaPath, this.viewSql);
            List<String> schemaPath1 = this.schemaPath != null ? this.schemaPath : this.schema.path(null);
            JavaTypeFactory typeFactory = MATERIALIZATION_CONNECTION.getTypeFactory();
            return new MaterializedViewTable(typeFactory.getJavaClass(parsed.rowType), RelDataTypeImpl.proto(parsed.rowType), this.viewSql, schemaPath1, this.viewPath, this.key);
        }
    }
}

