/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Supplier;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Suppliers;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.util.DateTimeUtils;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.config.NullCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelFieldCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDataTypeSpec;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDialectFactoryImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.AnsiSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.BasicSqlType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;
import com.alibaba.lindorm.thirdparty.org.slf4j.Logger;
import com.alibaba.lindorm.thirdparty.org.slf4j.LoggerFactory;
import java.sql.DatabaseMetaData;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class SqlDialect {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SqlDialect.class);
    public static final Context EMPTY_CONTEXT = SqlDialect.emptyContext();
    @Deprecated
    public static final SqlDialect DUMMY = AnsiSqlDialect.DEFAULT;
    @Deprecated
    public static final SqlDialect CALCITE = CalciteSqlDialect.DEFAULT;
    private final String identifierQuoteString;
    private final String identifierEndQuoteString;
    private final String identifierEscapedQuote;
    private final DatabaseProduct databaseProduct;
    protected final NullCollation nullCollation;
    private static final char[] HEXITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Deprecated
    public static SqlDialect create(DatabaseMetaData databaseMetaData) {
        return new SqlDialectFactoryImpl().create(databaseMetaData);
    }

    @Deprecated
    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString) {
        this(EMPTY_CONTEXT.withDatabaseProduct(databaseProduct).withDatabaseProductName(databaseProductName).withIdentifierQuoteString(identifierQuoteString));
    }

    @Deprecated
    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString, NullCollation nullCollation) {
        this(EMPTY_CONTEXT.withDatabaseProduct(databaseProduct).withDatabaseProductName(databaseProductName).withIdentifierQuoteString(identifierQuoteString).withNullCollation(nullCollation));
    }

    public SqlDialect(Context context) {
        this.nullCollation = Preconditions.checkNotNull(context.nullCollation());
        this.databaseProduct = Preconditions.checkNotNull(context.databaseProduct());
        String identifierQuoteString = context.identifierQuoteString();
        if (identifierQuoteString != null && (identifierQuoteString = identifierQuoteString.trim()).equals("")) {
            identifierQuoteString = null;
        }
        this.identifierQuoteString = identifierQuoteString;
        this.identifierEndQuoteString = identifierQuoteString == null ? null : (identifierQuoteString.equals("[") ? "]" : identifierQuoteString);
        this.identifierEscapedQuote = identifierQuoteString == null ? null : this.identifierEndQuoteString + this.identifierEndQuoteString;
    }

    protected static Context emptyContext() {
        return new ContextImpl(DatabaseProduct.UNKNOWN, null, null, -1, -1, null, NullCollation.HIGH);
    }

    @Deprecated
    public static DatabaseProduct getProduct(String productName, String productVersion) {
        String upperProductName;
        switch (upperProductName = productName.toUpperCase(Locale.ROOT).trim()) {
            case "ACCESS": {
                return DatabaseProduct.ACCESS;
            }
            case "APACHE DERBY": {
                return DatabaseProduct.DERBY;
            }
            case "DBMS:CLOUDSCAPE": {
                return DatabaseProduct.DERBY;
            }
            case "HIVE": {
                return DatabaseProduct.HIVE;
            }
            case "INGRES": {
                return DatabaseProduct.INGRES;
            }
            case "INTERBASE": {
                return DatabaseProduct.INTERBASE;
            }
            case "LUCIDDB": {
                return DatabaseProduct.LUCIDDB;
            }
            case "ORACLE": {
                return DatabaseProduct.ORACLE;
            }
            case "PHOENIX": {
                return DatabaseProduct.PHOENIX;
            }
            case "MYSQL (INFOBRIGHT)": {
                return DatabaseProduct.INFOBRIGHT;
            }
            case "MYSQL": {
                return DatabaseProduct.MYSQL;
            }
            case "REDSHIFT": {
                return DatabaseProduct.REDSHIFT;
            }
        }
        if (productName.startsWith("DB2")) {
            return DatabaseProduct.DB2;
        }
        if (upperProductName.contains("FIREBIRD")) {
            return DatabaseProduct.FIREBIRD;
        }
        if (productName.startsWith("Informix")) {
            return DatabaseProduct.INFORMIX;
        }
        if (upperProductName.contains("NETEZZA")) {
            return DatabaseProduct.NETEZZA;
        }
        if (upperProductName.contains("PARACCEL")) {
            return DatabaseProduct.PARACCEL;
        }
        if (productName.startsWith("HP Neoview")) {
            return DatabaseProduct.NEOVIEW;
        }
        if (upperProductName.contains("POSTGRE")) {
            return DatabaseProduct.POSTGRESQL;
        }
        if (upperProductName.contains("SQL SERVER")) {
            return DatabaseProduct.MSSQL;
        }
        if (upperProductName.contains("SYBASE")) {
            return DatabaseProduct.SYBASE;
        }
        if (upperProductName.contains("TERADATA")) {
            return DatabaseProduct.TERADATA;
        }
        if (upperProductName.contains("HSQL")) {
            return DatabaseProduct.HSQLDB;
        }
        if (upperProductName.contains("H2")) {
            return DatabaseProduct.H2;
        }
        if (upperProductName.contains("VERTICA")) {
            return DatabaseProduct.VERTICA;
        }
        if (upperProductName.contains("GOOGLE BIGQUERY")) {
            return DatabaseProduct.BIG_QUERY;
        }
        return DatabaseProduct.UNKNOWN;
    }

    public String quoteIdentifier(String val) {
        if (this.identifierQuoteString == null) {
            return val;
        }
        String val2 = val.replaceAll(this.identifierEndQuoteString, this.identifierEscapedQuote);
        return this.identifierQuoteString + val2 + this.identifierEndQuoteString;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, String val) {
        if (this.identifierQuoteString == null) {
            buf.append(val);
            return buf;
        }
        String val2 = val.replaceAll(this.identifierEndQuoteString, this.identifierEscapedQuote);
        buf.append(this.identifierQuoteString);
        buf.append(val2);
        buf.append(this.identifierEndQuoteString);
        return buf;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, List<String> identifiers) {
        int i = 0;
        for (String identifier : identifiers) {
            if (i++ > 0) {
                buf.append('.');
            }
            this.quoteIdentifier(buf, identifier);
        }
        return buf;
    }

    public boolean identifierNeedsToBeQuoted(String val) {
        return !Pattern.compile("^[A-Z_$0-9]+").matcher(val).matches();
    }

    public String quoteStringLiteral(String val) {
        if (SqlDialect.containsNonAscii(val)) {
            StringBuilder buf = new StringBuilder();
            this.quoteStringLiteralUnicode(buf, val);
            return buf.toString();
        }
        val = FakeUtil.replace(val, "'", "''");
        return "'" + val + "'";
    }

    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        call.getOperator().unparse(writer, call, leftPrec, rightPrec);
    }

    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        writer.literal(literal.toString());
    }

    private static boolean containsNonAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c < '\u0080') continue;
            return true;
        }
        return false;
    }

    public void quoteStringLiteralUnicode(StringBuilder buf, String val) {
        buf.append("u&'");
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c < ' ' || c >= '\u0080') {
                buf.append('\\');
                buf.append(HEXITS[c >> 12 & 0xF]);
                buf.append(HEXITS[c >> 8 & 0xF]);
                buf.append(HEXITS[c >> 4 & 0xF]);
                buf.append(HEXITS[c & 0xF]);
                continue;
            }
            if (c == '\'' || c == '\\') {
                buf.append(c);
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        buf.append("'");
    }

    public String unquoteStringLiteral(String val) {
        if (val != null && val.charAt(0) == '\'' && val.charAt(val.length() - 1) == '\'') {
            if (val.length() > 2) {
                val = FakeUtil.replace(val, "''", "'");
                return val.substring(1, val.length() - 1);
            }
            return "";
        }
        return val;
    }

    protected boolean allowsAs() {
        return true;
    }

    protected boolean requiresAliasForFromItems() {
        return false;
    }

    public boolean hasImplicitTableAlias() {
        return true;
    }

    public String quoteTimestampLiteral(Timestamp timestamp) {
        SimpleDateFormat format = new SimpleDateFormat("'TIMESTAMP' ''yyyy-MM-DD HH:mm:SS''", Locale.ROOT);
        format.setTimeZone(DateTimeUtils.UTC_ZONE);
        return format.format(timestamp);
    }

    @Deprecated
    public DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    public boolean supportsCharSet() {
        return true;
    }

    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case COUNT: 
            case SUM: 
            case SUM0: 
            case MIN: 
            case MAX: {
                return true;
            }
        }
        return false;
    }

    public CalendarPolicy getCalendarPolicy() {
        return CalendarPolicy.NULL;
    }

    public SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            return new SqlDataTypeSpec(new SqlIdentifier(type.getSqlTypeName().name(), SqlParserPos.ZERO), type.getPrecision(), type.getScale(), type.getCharset() != null && this.supportsCharSet() ? type.getCharset().name() : null, null, SqlParserPos.ZERO);
        }
        return SqlTypeUtil.convertTypeToSpec(type);
    }

    public SqlNode rewriteSingleValueExpr(SqlNode aggCall) {
        LOGGER.debug("SINGLE_VALUE rewrite not supported for {}", (Object)this.databaseProduct);
        return aggCall;
    }

    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return null;
    }

    protected SqlNode emulateNullDirectionWithIsNull(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.nullCollation.isDefaultOrder(nullsFirst, desc)) {
            return null;
        }
        node = SqlStdOperatorTable.IS_NULL.createCall(SqlParserPos.ZERO, node);
        if (nullsFirst) {
            node = SqlStdOperatorTable.DESC.createCall(SqlParserPos.ZERO, node);
        }
        return node;
    }

    public boolean supportsOffsetFetch() {
        return true;
    }

    public boolean supportsNestedAggregations() {
        return true;
    }

    public NullCollation getNullCollation() {
        return this.nullCollation;
    }

    public RelFieldCollation.NullDirection defaultNullDirection(RelFieldCollation.Direction direction) {
        switch (direction) {
            case ASCENDING: 
            case STRICTLY_ASCENDING: {
                return this.getNullCollation().last(false) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return this.getNullCollation().last(true) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
        }
        return RelFieldCollation.NullDirection.UNSPECIFIED;
    }

    public boolean supportsAliasedValues() {
        return true;
    }

    private static class ContextImpl
    implements Context {
        private final DatabaseProduct databaseProduct;
        private final String databaseProductName;
        private final String databaseVersion;
        private final int databaseMajorVersion;
        private final int databaseMinorVersion;
        private final String identifierQuoteString;
        private final NullCollation nullCollation;

        private ContextImpl(DatabaseProduct databaseProduct, String databaseProductName, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, String identifierQuoteString, NullCollation nullCollation) {
            this.databaseProduct = Preconditions.checkNotNull(databaseProduct);
            this.databaseProductName = databaseProductName;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.identifierQuoteString = identifierQuoteString;
            this.nullCollation = Preconditions.checkNotNull(nullCollation);
        }

        @Override
        @Nonnull
        public DatabaseProduct databaseProduct() {
            return this.databaseProduct;
        }

        @Override
        public Context withDatabaseProduct(@Nonnull DatabaseProduct databaseProduct) {
            return new ContextImpl(databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation);
        }

        @Override
        public String databaseProductName() {
            return this.databaseProductName;
        }

        @Override
        public Context withDatabaseProductName(String databaseProductName) {
            return new ContextImpl(this.databaseProduct, databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation);
        }

        @Override
        public String databaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public Context withDatabaseVersion(String databaseVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation);
        }

        @Override
        public int databaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        @Override
        public Context withDatabaseMajorVersion(int databaseMajorVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation);
        }

        @Override
        public int databaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        @Override
        public Context withDatabaseMinorVersion(int databaseMinorVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, databaseMinorVersion, this.identifierQuoteString, this.nullCollation);
        }

        @Override
        public String identifierQuoteString() {
            return this.identifierQuoteString;
        }

        @Override
        public Context withIdentifierQuoteString(String identifierQuoteString) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, identifierQuoteString, this.nullCollation);
        }

        @Override
        @Nonnull
        public NullCollation nullCollation() {
            return this.nullCollation;
        }

        @Override
        public Context withNullCollation(@Nonnull NullCollation nullCollation) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, nullCollation);
        }
    }

    public static interface Context {
        @Nonnull
        public DatabaseProduct databaseProduct();

        public Context withDatabaseProduct(@Nonnull DatabaseProduct var1);

        public String databaseProductName();

        public Context withDatabaseProductName(String var1);

        public String databaseVersion();

        public Context withDatabaseVersion(String var1);

        public int databaseMajorVersion();

        public Context withDatabaseMajorVersion(int var1);

        public int databaseMinorVersion();

        public Context withDatabaseMinorVersion(int var1);

        public String identifierQuoteString();

        public Context withIdentifierQuoteString(String var1);

        @Nonnull
        public NullCollation nullCollation();

        public Context withNullCollation(@Nonnull NullCollation var1);
    }

    public static enum DatabaseProduct {
        ACCESS("Access", "\"", NullCollation.HIGH),
        BIG_QUERY("Google BigQuery", "`", NullCollation.LOW),
        CALCITE("Apache Calcite", "\"", NullCollation.HIGH),
        MSSQL("Microsoft SQL Server", "[", NullCollation.HIGH),
        MYSQL("MySQL", "`", NullCollation.LOW),
        ORACLE("Oracle", "\"", NullCollation.HIGH),
        DERBY("Apache Derby", null, NullCollation.HIGH),
        DB2("IBM DB2", null, NullCollation.HIGH),
        FIREBIRD("Firebird", null, NullCollation.HIGH),
        H2("H2", "\"", NullCollation.HIGH),
        HIVE("Apache Hive", null, NullCollation.LOW),
        INFORMIX("Informix", null, NullCollation.HIGH),
        INGRES("Ingres", null, NullCollation.HIGH),
        LUCIDDB("LucidDB", "\"", NullCollation.HIGH),
        INTERBASE("Interbase", null, NullCollation.HIGH),
        PHOENIX("Phoenix", "\"", NullCollation.HIGH),
        POSTGRESQL("PostgreSQL", "\"", NullCollation.HIGH),
        NETEZZA("Netezza", "\"", NullCollation.HIGH),
        INFOBRIGHT("Infobright", "`", NullCollation.HIGH),
        NEOVIEW("Neoview", null, NullCollation.HIGH),
        SYBASE("Sybase", null, NullCollation.HIGH),
        TERADATA("Teradata", "\"", NullCollation.HIGH),
        HSQLDB("Hsqldb", null, NullCollation.HIGH),
        VERTICA("Vertica", "\"", NullCollation.HIGH),
        SQLSTREAM("SQLstream", "\"", NullCollation.HIGH),
        PARACCEL("Paraccel", "\"", NullCollation.HIGH),
        REDSHIFT("Redshift", "\"", NullCollation.HIGH),
        UNKNOWN("Unknown", "`", NullCollation.HIGH);

        private final Supplier<SqlDialect> dialect = Suppliers.memoize(new Supplier<SqlDialect>(){

            @Override
            public SqlDialect get() {
                SqlDialect dialect = SqlDialectFactoryImpl.simple(DatabaseProduct.this);
                if (dialect != null) {
                    return dialect;
                }
                return new SqlDialect(EMPTY_CONTEXT.withDatabaseProduct(DatabaseProduct.this).withDatabaseProductName(DatabaseProduct.this.databaseProductName).withIdentifierQuoteString(DatabaseProduct.this.quoteString).withNullCollation(DatabaseProduct.this.nullCollation));
            }
        });
        private String databaseProductName;
        private String quoteString;
        private final NullCollation nullCollation;

        private DatabaseProduct(String databaseProductName, String quoteString, NullCollation nullCollation) {
            this.databaseProductName = Preconditions.checkNotNull(databaseProductName);
            this.quoteString = quoteString;
            this.nullCollation = Preconditions.checkNotNull(nullCollation);
        }

        public SqlDialect getDialect() {
            return this.dialect.get();
        }
    }

    public static enum CalendarPolicy {
        NONE,
        NULL,
        LOCAL,
        DIRECT,
        SHIFT;

    }

    public static class FakeUtil {
        public static Error newInternal(Throwable e, String s) {
            String message = "Internal error: \u0000" + s;
            AssertionError ae = new AssertionError((Object)message);
            ((Throwable)((Object)ae)).initCause(e);
            return ae;
        }

        public static String replace(String s, String find, String replace) {
            int found = s.indexOf(find);
            if (found == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder(s.length());
            int start = 0;
            while (true) {
                if (start < found) {
                    sb.append(s.charAt(start));
                    ++start;
                    continue;
                }
                if (found == s.length()) break;
                sb.append(replace);
                found = s.indexOf(find, start += find.length());
                if (found != -1) continue;
                found = s.length();
            }
            return sb.toString();
        }
    }
}

