/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunctionalOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperatorBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.ArraySqlType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.MapSqlType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.MultisetSqlType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;

public class SqlUnnestOperator
extends SqlFunctionalOperator {
    public final boolean withOrdinality;
    public static final String ORDINALITY_COLUMN_NAME = "ORDINALITY";
    public static final String MAP_KEY_COLUMN_NAME = "KEY";
    public static final String MAP_VALUE_COLUMN_NAME = "VALUE";

    public SqlUnnestOperator(boolean withOrdinality) {
        super("UNNEST", SqlKind.UNNEST, 200, true, null, null, OperandTypes.repeat(SqlOperandCountRanges.from(1), OperandTypes.SCALAR_OR_RECORD_COLLECTION_OR_MAP));
        this.withOrdinality = withOrdinality;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory.FieldInfoBuilder builder = opBinding.getTypeFactory().builder();
        for (Integer operand : Util.range(opBinding.getOperandCount())) {
            RelDataType type = opBinding.getOperandType(operand);
            if (type.isStruct()) {
                type = type.getFieldList().get(0).getType();
            }
            assert (type instanceof ArraySqlType || type instanceof MultisetSqlType || type instanceof MapSqlType);
            if (type instanceof MapSqlType) {
                ((RelDataTypeFactory.Builder)builder).add(MAP_KEY_COLUMN_NAME, type.getKeyType());
                ((RelDataTypeFactory.Builder)builder).add(MAP_VALUE_COLUMN_NAME, type.getValueType());
                continue;
            }
            if (type.getComponentType().isStruct()) {
                ((RelDataTypeFactory.Builder)builder).addAll(type.getComponentType().getFieldList());
                continue;
            }
            ((RelDataTypeFactory.Builder)builder).add(SqlUtil.deriveAliasFromOrdinal(operand), type.getComponentType());
        }
        if (this.withOrdinality) {
            ((RelDataTypeFactory.Builder)builder).add(ORDINALITY_COLUMN_NAME, SqlTypeName.INTEGER);
        }
        return builder.build();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        super.unparse(writer, call, leftPrec, rightPrec);
        if (this.withOrdinality) {
            writer.keyword("WITH ORDINALITY");
        }
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

