/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDrop;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlExecutableStatement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import java.util.List;

abstract class SqlDropObject
extends SqlDrop
implements SqlExecutableStatement {
    protected final SqlIdentifier name;

    SqlDropObject(SqlOperator operator, SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        super(operator, pos, ifExists);
        this.name = name;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        List<String> path = context.getDefaultSchemaPath();
        CalciteSchema schema = context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        switch (this.getKind()) {
            case DROP_TABLE: 
            case DROP_MATERIALIZED_VIEW: {
                boolean existed = schema.removeTable(this.name.getSimple());
                if (existed || this.ifExists) break;
                throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.tableNotFound(this.name.getSimple()));
            }
            case DROP_VIEW: {
                boolean existed = schema.removeFunction(this.name.getSimple());
                if (existed || this.ifExists) break;
                throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.viewNotFound(this.name.getSimple()));
            }
            default: {
                throw new AssertionError((Object)this.getKind());
            }
        }
    }
}

