/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlBinaryOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperandCountRange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.InferTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.ReturnTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;

public class SqlOverlapsOperator
extends SqlBinaryOperator {
    SqlOverlapsOperator(SqlKind kind) {
        super(kind.sql, kind, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.sequence("'<PERIOD> " + kind.sql + " <PERIOD>'", OperandTypes.PERIOD, OperandTypes.PERIOD));
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        this.arg(writer, call, leftPrec, rightPrec, 0);
        writer.sep(this.getName());
        this.arg(writer, call, leftPrec, rightPrec, 1);
        writer.endList(frame);
    }

    void arg(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec, int i) {
        if (SqlUtil.isCallTo(call.operand(i), SqlStdOperatorTable.ROW)) {
            SqlCall row = (SqlCall)call.operand(i);
            writer.keyword("PERIOD");
            writer.sep("(", true);
            ((SqlNode)row.operand(0)).unparse(writer, leftPrec, rightPrec);
            writer.sep(",", true);
            ((SqlNode)row.operand(1)).unparse(writer, leftPrec, rightPrec);
            writer.sep(")", true);
        } else {
            ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public String getAllowedSignatures(String opName) {
        String d = "DATETIME";
        String i = "INTERVAL";
        String[] typeNames = new String[]{"DATETIME", "DATETIME", "DATETIME", "INTERVAL", "INTERVAL", "DATETIME", "INTERVAL", "INTERVAL"};
        StringBuilder ret = new StringBuilder();
        for (int y = 0; y < typeNames.length; y += 2) {
            if (y > 0) {
                ret.append(NL);
            }
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of("DATETIME", typeNames[y], "DATETIME", typeNames[y + 1])));
        }
        return ret.toString();
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType t10;
        RelDataType t00;
        SqlSingleOperandTypeChecker rightChecker;
        if (!OperandTypes.PERIOD.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure)) {
            return false;
        }
        switch (this.kind) {
            case CONTAINS: {
                rightChecker = OperandTypes.PERIOD_OR_DATETIME;
                break;
            }
            default: {
                rightChecker = OperandTypes.PERIOD;
            }
        }
        if (!rightChecker.checkSingleOperandType(callBinding, callBinding.operand(1), 0, throwOnFailure)) {
            return false;
        }
        RelDataType t0 = callBinding.getOperandType(0);
        RelDataType t1 = callBinding.getOperandType(1);
        if (!SqlTypeUtil.isDatetime(t1) && !SqlTypeUtil.sameNamedType(t00 = t0.getFieldList().get(0).getType(), t10 = t1.getFieldList().get(0).getType())) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }
}

