/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.ExplicitOperandTypeInference;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import java.util.List;

public abstract class InferTypes {
    public static final SqlOperandTypeInference FIRST_KNOWN = new SqlOperandTypeInference(){

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataType unknownType;
            RelDataType knownType = unknownType = callBinding.getValidator().getUnknownType();
            for (SqlNode operand : callBinding.operands()) {
                knownType = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
                if (knownType.equals(unknownType)) continue;
                break;
            }
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = knownType;
            }
        }
    };
    public static final SqlOperandTypeInference RETURN_TYPE = new SqlOperandTypeInference(){

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = returnType.isStruct() ? returnType.getFieldList().get(i).getType() : returnType;
            }
        }
    };
    public static final SqlOperandTypeInference BOOLEAN = new SqlOperandTypeInference(){

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
        }
    };
    public static final SqlOperandTypeInference VARCHAR_1024 = new SqlOperandTypeInference(){

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.VARCHAR, 1024);
            }
        }
    };

    private InferTypes() {
    }

    public static SqlOperandTypeInference explicit(List<RelDataType> types) {
        return new ExplicitOperandTypeInference(ImmutableList.copyOf(types));
    }
}

