/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperatorBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeTransform;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.List;

public abstract class SqlTypeTransforms {
    public static final SqlTypeTransform TO_NULLABLE = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return SqlTypeUtil.makeNullableIfOperandsAre(opBinding.getTypeFactory(), opBinding.collectOperandTypes(), Preconditions.checkNotNull(typeToTransform));
        }
    };
    public static final SqlTypeTransform TO_NULLABLE_ALL = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType type) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(type, SqlTypeUtil.allNullable(opBinding.collectOperandTypes()));
        }
    };
    public static final SqlTypeTransform TO_NOT_NULLABLE = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return opBinding.getTypeFactory().createTypeWithNullability(Preconditions.checkNotNull(typeToTransform), false);
        }
    };
    public static final SqlTypeTransform FORCE_NULLABLE = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return opBinding.getTypeFactory().createTypeWithNullability(Preconditions.checkNotNull(typeToTransform), true);
        }
    };
    public static final SqlTypeTransform TO_VARYING = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            switch (typeToTransform.getSqlTypeName()) {
                case VARCHAR: 
                case VARBINARY: {
                    return typeToTransform;
                }
            }
            SqlTypeName retTypeName = this.toVar(typeToTransform);
            RelDataType ret = opBinding.getTypeFactory().createSqlType(retTypeName, typeToTransform.getPrecision());
            if (SqlTypeUtil.inCharFamily(typeToTransform)) {
                ret = opBinding.getTypeFactory().createTypeWithCharsetAndCollation(ret, typeToTransform.getCharset(), typeToTransform.getCollation());
            }
            return opBinding.getTypeFactory().createTypeWithNullability(ret, typeToTransform.isNullable());
        }

        private SqlTypeName toVar(RelDataType type) {
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            switch (sqlTypeName) {
                case CHAR: {
                    return SqlTypeName.VARCHAR;
                }
                case BINARY: {
                    return SqlTypeName.VARBINARY;
                }
                case ANY: {
                    return SqlTypeName.ANY;
                }
            }
            throw Util.unexpected(sqlTypeName);
        }
    };
    public static final SqlTypeTransform TO_MULTISET_ELEMENT_TYPE = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return typeToTransform.getComponentType();
        }
    };
    public static final SqlTypeTransform TO_MULTISET = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return opBinding.getTypeFactory().createMultisetType(typeToTransform, -1L);
        }
    };
    public static final SqlTypeTransform ONLY_COLUMN = new SqlTypeTransform(){

        @Override
        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            List<RelDataTypeField> fields = typeToTransform.getFieldList();
            assert (fields.size() == 1);
            return fields.get(0).getType();
        }
    };
}

