/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.util;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.function.Function1;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import com.alibaba.lindorm.thirdparty.org.slf4j.Logger;
import com.alibaba.lindorm.thirdparty.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Benchmark {
    public static final Logger LOGGER = LoggerFactory.getLogger(Benchmark.class);
    private final Function1<Statistician, Void> function;
    private final int repeat;
    private final Statistician statistician;

    public Benchmark(String description, Function1<Statistician, Void> function, int repeat) {
        this.function = function;
        this.repeat = repeat;
        this.statistician = new Statistician(description);
    }

    public static boolean enabled() {
        return LOGGER.isDebugEnabled();
    }

    static long printDuration(String desc, long t0) {
        long t1 = System.nanoTime();
        long duration = t1 - t0;
        LOGGER.debug("{} took {} nanos", (Object)desc, (Object)duration);
        return duration;
    }

    public void run() {
        for (int i = 0; i < this.repeat; ++i) {
            this.function.apply(this.statistician);
        }
        this.statistician.printDurations();
    }

    public static class Statistician {
        private final String desc;
        private final List<Long> durations = new ArrayList<Long>();

        public Statistician(String desc) {
            this.desc = desc;
        }

        public void record(long start) {
            this.durations.add(Benchmark.printDuration(this.desc + " iteration #" + (this.durations.size() + 1), start));
        }

        private void printDurations() {
            if (!LOGGER.isDebugEnabled()) {
                return;
            }
            List<Long> coreDurations = this.durations;
            String durationsString = this.durations.toString();
            if (coreDurations.size() > 3) {
                coreDurations = this.durations.subList(3, this.durations.size());
            }
            Collections.sort(coreDurations);
            List<Long> coreCoreDurations = coreDurations;
            if (coreDurations.size() > 4) {
                coreCoreDurations = coreDurations.subList(1, coreDurations.size() - 1);
            }
            long sum = 0L;
            int count = coreCoreDurations.size();
            for (long duration : coreCoreDurations) {
                sum += duration;
            }
            double avg = (double)sum / (double)count;
            double y = 0.0;
            for (long duration : coreCoreDurations) {
                double x = (double)duration - avg;
                y += x * x;
            }
            double stddev = Math.sqrt(y / (double)count);
            if (this.durations.size() == 0) {
                LOGGER.debug("{}: {}", (Object)this.desc, (Object)"no runs");
            } else {
                LOGGER.debug("{}: {} first; {} +- {}; {} min; {} max; {} nanos", this.desc, this.durations.get(0), avg, stddev, coreDurations.get(0), Util.last(coreDurations), durationsString);
            }
        }
    }
}

