/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.util;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableSortedMap;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.NameSet;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class NameMap<V> {
    private final NavigableMap<String, V> map;

    private NameMap(NavigableMap<String, V> map) {
        this.map = map;
        assert (this.map.comparator() == NameSet.COMPARATOR);
    }

    public NameMap() {
        this(new TreeMap(NameSet.COMPARATOR));
    }

    public static <V> NameMap immutableCopyOf(Map<String, V> names) {
        return new NameMap<V>(ImmutableSortedMap.copyOf(names, NameSet.COMPARATOR));
    }

    public void put(String name, V v) {
        this.map.put(name, v);
    }

    public NavigableMap<String, V> range(String name, boolean caseSensitive) {
        if (caseSensitive) {
            if (this.map.containsKey(name)) {
                return ImmutableSortedMap.of(name, this.map.get(name));
            }
            return ImmutableSortedMap.of();
        }
        return this.map.subMap(name.toUpperCase(Locale.ROOT), true, name.toLowerCase(Locale.ROOT), true);
    }

    public boolean containsKey(String name, boolean caseSensitive) {
        return !this.range(name, caseSensitive).isEmpty();
    }

    public NavigableMap<String, V> map() {
        return this.map;
    }

    public V remove(String key) {
        return this.map.remove(key);
    }
}

