/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.sqlline;

import com.alibaba.lindorm.thirdparty.sqlline.Rows;
import com.alibaba.lindorm.thirdparty.sqlline.SqlLine;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class BufferedRows
extends Rows {
    private final List<Rows.Row> list = new LinkedList<Rows.Row>();
    private final Iterator<Rows.Row> iterator;

    BufferedRows(SqlLine sqlLine, ResultSet rs) throws SQLException {
        super(sqlLine, rs);
        int count = this.rsMeta.getColumnCount();
        this.list.add(new Rows.Row(count));
        while (rs.next()) {
            this.list.add(new Rows.Row(count, rs));
        }
        this.iterator = this.list.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Rows.Row next() {
        return this.iterator.next();
    }

    @Override
    void normalizeWidths() {
        int[] max = null;
        for (Rows.Row row : this.list) {
            if (max == null) {
                max = new int[row.values.length];
            }
            for (int j = 0; j < max.length; ++j) {
                max[j] = Math.max(max[j], row.sizes[j] + 1);
            }
        }
        for (Rows.Row row : this.list) {
            row.sizes = max;
        }
    }
}

