/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.sqlline;

import com.alibaba.lindorm.thirdparty.sqlline.SqlLine;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;

abstract class Rows
implements Iterator<Row> {
    protected final SqlLine sqlLine;
    final ResultSetMetaData rsMeta;
    final Boolean[] primaryKeys;
    final NumberFormat numberFormat;

    Rows(SqlLine sqlLine, ResultSet rs) throws SQLException {
        this.sqlLine = sqlLine;
        this.rsMeta = rs.getMetaData();
        int count = this.rsMeta.getColumnCount();
        this.primaryKeys = new Boolean[count];
        this.numberFormat = sqlLine.getOpts().getNumberFormat().equals("default") ? null : new DecimalFormat(sqlLine.getOpts().getNumberFormat());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    abstract void normalizeWidths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isPrimaryKey(int col) {
        if (this.primaryKeys[col] != null) {
            return this.primaryKeys[col];
        }
        try {
            String table = this.rsMeta.getTableName(col + 1);
            String column = this.rsMeta.getColumnName(col + 1);
            if (table == null || table.length() == 0 || column == null || column.length() == 0) {
                this.primaryKeys[col] = false;
                return this.primaryKeys[col];
            }
            ResultSet pks = this.sqlLine.getDatabaseConnection().meta.getPrimaryKeys(this.sqlLine.getDatabaseConnection().meta.getConnection().getCatalog(), null, table);
            try {
                while (pks.next()) {
                    if (!column.equalsIgnoreCase(pks.getString("COLUMN_NAME"))) continue;
                    this.primaryKeys[col] = true;
                    boolean bl = this.primaryKeys[col];
                    return bl;
                }
            }
            finally {
                pks.close();
            }
            this.primaryKeys[col] = false;
            return this.primaryKeys[col];
        }
        catch (SQLException sqle) {
            this.primaryKeys[col] = false;
            return this.primaryKeys[col];
        }
    }

    class Row {
        final String[] values;
        final boolean isMeta;
        protected boolean deleted;
        protected boolean inserted;
        protected boolean updated;
        protected int[] sizes;

        Row(int size) throws SQLException {
            this.isMeta = true;
            this.values = new String[size];
            this.sizes = new int[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = Rows.this.rsMeta.getColumnLabel(i + 1);
                this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
            }
            this.deleted = false;
            this.updated = false;
            this.inserted = false;
        }

        Row(int size, ResultSet rs) throws SQLException {
            this.isMeta = false;
            this.values = new String[size];
            this.sizes = new int[size];
            try {
                this.deleted = rs.rowDeleted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.updated = rs.rowUpdated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.inserted = rs.rowInserted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 0; i < size; ++i) {
                switch (rs.getMetaData().getColumnType(i + 1)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        Object o = rs.getObject(i + 1);
                        if (o == null) {
                            this.values[i] = "null";
                            break;
                        }
                        if (Rows.this.numberFormat != null) {
                            this.values[i] = Rows.this.numberFormat.format(o);
                            break;
                        }
                        this.values[i] = o.toString();
                        break;
                    }
                    case -8: 
                    case -7: 
                    case 2000: 
                    case 2002: 
                    case 2004: 
                    case 2005: 
                    case 2006: 
                    case 2009: 
                    case 2011: {
                        Object o = rs.getObject(i + 1);
                        if (o == null) {
                            this.values[i] = "null";
                            break;
                        }
                        this.values[i] = o.toString();
                        break;
                    }
                    default: {
                        this.values[i] = rs.getString(i + 1);
                    }
                }
                this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
            }
        }
    }
}

