/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.sqlline;

import com.alibaba.lindorm.thirdparty.sqlline.ColorBuffer;
import com.alibaba.lindorm.thirdparty.sqlline.OutputFormat;
import com.alibaba.lindorm.thirdparty.sqlline.Rows;
import com.alibaba.lindorm.thirdparty.sqlline.SqlLine;

class TableOutputFormat
implements OutputFormat {
    private final SqlLine sqlLine;

    public TableOutputFormat(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    @Override
    public int print(Rows rows) {
        int index = 0;
        ColorBuffer header = null;
        ColorBuffer headerCols = null;
        int width = this.sqlLine.getOpts().getMaxWidth() - 4;
        rows.normalizeWidths();
        while (rows.hasNext()) {
            Rows.Row row = (Rows.Row)rows.next();
            ColorBuffer cbuf = this.getOutputString(rows, row);
            cbuf = cbuf.truncate(width);
            if (index == 0) {
                StringBuilder h = new StringBuilder();
                for (int j = 0; j < row.sizes.length; ++j) {
                    for (int k = 0; k < row.sizes[j]; ++k) {
                        h.append('-');
                    }
                    h.append("-+-");
                }
                headerCols = cbuf;
                header = this.sqlLine.getColorBuffer().green(h.toString()).truncate(headerCols.getVisibleLength());
            }
            if (index == 0 || this.sqlLine.getOpts().getHeaderInterval() > 0 && index % this.sqlLine.getOpts().getHeaderInterval() == 0 && this.sqlLine.getOpts().getShowHeader()) {
                this.printRow(header, true);
                this.printRow(headerCols, false);
                this.printRow(header, true);
            }
            if (index != 0) {
                this.printRow(cbuf, false);
            }
            ++index;
        }
        if (header != null && this.sqlLine.getOpts().getShowHeader()) {
            this.printRow(header, true);
        }
        return index - 1;
    }

    void printRow(ColorBuffer cbuff, boolean header) {
        if (header) {
            this.sqlLine.output(this.sqlLine.getColorBuffer().green("+-").append(cbuff).green("-+"));
        } else {
            this.sqlLine.output(this.sqlLine.getColorBuffer().green("| ").append(cbuff).green(" |"));
        }
    }

    public ColorBuffer getOutputString(Rows rows, Rows.Row row) {
        return this.getOutputString(rows, row, " | ");
    }

    ColorBuffer getOutputString(Rows rows, Rows.Row row, String delim) {
        ColorBuffer buf = this.sqlLine.getColorBuffer();
        for (int i = 0; i < row.values.length; ++i) {
            ColorBuffer v;
            if (buf.getVisibleLength() > 0) {
                buf.green(delim);
            }
            if (row.isMeta) {
                v = this.sqlLine.getColorBuffer().center(row.values[i], row.sizes[i]);
                if (rows.isPrimaryKey(i)) {
                    buf.cyan(v.getMono());
                    continue;
                }
                buf.bold(v.getMono());
                continue;
            }
            v = this.sqlLine.getColorBuffer().pad(row.values[i], row.sizes[i]);
            if (rows.isPrimaryKey(i)) {
                buf.cyan(v.getMono());
                continue;
            }
            buf.append(v.getMono());
        }
        if (row.deleted) {
            buf = this.sqlLine.getColorBuffer().red(buf.getMono());
        } else if (row.updated) {
            buf = this.sqlLine.getColorBuffer().blue(buf.getMono());
        } else if (row.inserted) {
            buf = this.sqlLine.getColorBuffer().green(buf.getMono());
        }
        return buf;
    }
}

