/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ClassFactory {
    protected static final Logger log = Logger.getLogger(ClassFactory.class.getName());
    private static final ArrayList<Allow> _staticAllowList;
    private static final Map<String, Object> _allowClassSet;
    private ClassLoader _loader;
    private boolean _isWhitelist;
    private LinkedList<Allow> _allowList;

    ClassFactory(ClassLoader loader) {
        this._loader = loader;
        this.initAllow();
    }

    public Class<?> load(String className) throws ClassNotFoundException {
        if (this.isAllow(className)) {
            return Class.forName(className, false, this._loader);
        }
        log.log(Level.SEVERE, className + " in blacklist or not in whitelist, deserialization  with type 'HashMap' instead.");
        return HashMap.class;
    }

    private boolean isAllow(String className) {
        LinkedList<Allow> allowList = this._allowList;
        if (allowList == null) {
            return true;
        }
        if (_allowClassSet.containsKey(className)) {
            return true;
        }
        int size = allowList.size();
        for (int i = 0; i < size; ++i) {
            Allow allow = allowList.get(i);
            Boolean isAllow = allow.allow(className);
            if (isAllow == null) continue;
            if (isAllow.booleanValue()) {
                _allowClassSet.put(className, className);
            }
            return isAllow;
        }
        if (this._isWhitelist) {
            return false;
        }
        _allowClassSet.put(className, className);
        return true;
    }

    public void setWhitelist(boolean isWhitelist) {
        _allowClassSet.clear();
        this._isWhitelist = isWhitelist;
        this.initAllow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allow(String pattern) {
        _allowClassSet.clear();
        this.initAllow();
        ClassFactory classFactory = this;
        synchronized (classFactory) {
            this._allowList.addFirst(new Allow(this.toPattern(pattern), true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deny(String pattern) {
        _allowClassSet.clear();
        this.initAllow();
        ClassFactory classFactory = this;
        synchronized (classFactory) {
            this._allowList.addFirst(new Allow(this.toPattern(pattern), false));
        }
    }

    private String toPattern(String pattern) {
        pattern = pattern.replace(".", "\\.");
        pattern = pattern.replace("*", ".*");
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAllow() {
        ClassFactory classFactory = this;
        synchronized (classFactory) {
            if (this._allowList == null) {
                this._allowList = new LinkedList();
                this._allowList.addAll(_staticAllowList);
            }
        }
    }

    public static String[] readLines(InputStream is) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            String[] stringArray = lines.toArray(new String[0]);
            return stringArray;
        }
    }

    static {
        _allowClassSet = new ConcurrentHashMap<String, Object>();
        _staticAllowList = new ArrayList();
        ClassLoader classLoader = ClassFactory.class.getClassLoader();
        try {
            String[] denyClasses;
            for (String denyClass : denyClasses = ClassFactory.readLines(classLoader.getResourceAsStream("DENY_CLASS"))) {
                if (denyClass.startsWith("#")) continue;
                _staticAllowList.add(new AllowPrefix(denyClass, false));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class AllowPrefix
    extends Allow {
        private Boolean _isAllow;
        private String _prefix;

        private AllowPrefix(String prefix, boolean isAllow) {
            this._isAllow = isAllow;
            this._prefix = prefix;
        }

        @Override
        Boolean allow(String className) {
            if (className.startsWith(this._prefix)) {
                return this._isAllow;
            }
            return null;
        }
    }

    static class Allow {
        private Boolean _isAllow;
        private Pattern _pattern;

        public Allow() {
        }

        private Allow(String pattern, boolean isAllow) {
            this._isAllow = isAllow;
            this._pattern = Pattern.compile(pattern);
        }

        Boolean allow(String className) {
            if (this._pattern.matcher(className).matches()) {
                return this._isAllow;
            }
            return null;
        }
    }
}

