/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common;

import com.alibaba.rocketmq.common.TopicFilterType;
import com.alibaba.rocketmq.common.constant.PermName;

public class TopicConfig {
    public static int DefaultReadQueueNums = 16;
    public static int DefaultWriteQueueNums = 16;
    private static final String SEPARATOR = " ";
    private String topicName;
    private int readQueueNums = DefaultReadQueueNums;
    private int writeQueueNums = DefaultWriteQueueNums;
    private int perm = 6;
    private TopicFilterType topicFilterType = TopicFilterType.SINGLE_TAG;

    public TopicConfig() {
    }

    public TopicConfig(String topicName) {
        this.topicName = topicName;
    }

    public TopicConfig(String topicName, int readQueueNums, int writeQueueNums, int perm) {
        this.topicName = topicName;
        this.readQueueNums = readQueueNums;
        this.writeQueueNums = writeQueueNums;
        this.perm = perm;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.topicName);
        sb.append(SEPARATOR);
        sb.append(this.readQueueNums);
        sb.append(SEPARATOR);
        sb.append(this.writeQueueNums);
        sb.append(SEPARATOR);
        sb.append(this.perm);
        sb.append(SEPARATOR);
        sb.append((Object)this.topicFilterType);
        return sb.toString();
    }

    public boolean decode(String in) {
        String[] strs = in.split(SEPARATOR);
        if (strs != null && strs.length == 5) {
            this.topicName = strs[0];
            this.readQueueNums = Integer.parseInt(strs[1]);
            this.writeQueueNums = Integer.parseInt(strs[2]);
            this.perm = Integer.parseInt(strs[3]);
            this.topicFilterType = TopicFilterType.valueOf(strs[4]);
            return true;
        }
        return false;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public int getReadQueueNums() {
        return this.readQueueNums;
    }

    public void setReadQueueNums(int readQueueNums) {
        this.readQueueNums = readQueueNums;
    }

    public int getWriteQueueNums() {
        return this.writeQueueNums;
    }

    public void setWriteQueueNums(int writeQueueNums) {
        this.writeQueueNums = writeQueueNums;
    }

    public int getPerm() {
        return this.perm;
    }

    public void setPerm(int perm) {
        this.perm = perm;
    }

    public TopicFilterType getTopicFilterType() {
        return this.topicFilterType;
    }

    public void setTopicFilterType(TopicFilterType topicFilterType) {
        this.topicFilterType = topicFilterType;
    }

    public boolean equals(Object obj) {
        TopicConfig other = (TopicConfig)obj;
        if (other != null) {
            return this.topicName.equals(other.topicName) && this.readQueueNums == other.readQueueNums && this.writeQueueNums == other.writeQueueNums && this.perm == other.perm && this.topicFilterType == other.topicFilterType;
        }
        return false;
    }

    public String toString() {
        return "TopicConfig [topicName=" + this.topicName + ", readQueueNums=" + this.readQueueNums + ", writeQueueNums=" + this.writeQueueNums + ", perm=" + PermName.perm2String(this.perm) + ", topicFilterType=" + (Object)((Object)this.topicFilterType) + "]";
    }
}

