/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.filter;

import com.alibaba.rocketmq.common.filter.MessageFilter;
import com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import java.net.URL;

public class FilterAPI {
    public static String simpleClassName(String className) {
        String simple = className;
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            simple = className.substring(index + 1);
        }
        return simple;
    }

    public static URL classFile(String className) {
        String javaSource = FilterAPI.simpleClassName(className) + ".java";
        URL url = FilterAPI.class.getClassLoader().getResource(javaSource);
        return url;
    }

    public static boolean isFilterClassMode(String subString) {
        try {
            if (subString.contains(".")) {
                Class<?> loadClass = FilterAPI.class.getClassLoader().loadClass(subString);
                Class<?>[] interfaces = loadClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!interfaces[i].getCanonicalName().equals(MessageFilter.class.getCanonicalName())) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static SubscriptionData buildSubscriptionData(String consumerGroup, String topic, String subString) throws Exception {
        SubscriptionData subscriptionData = new SubscriptionData();
        subscriptionData.setTopic(topic);
        subscriptionData.setSubString(subString);
        if (null == subString || subString.equals("*") || subString.length() == 0) {
            subscriptionData.setSubString("*");
        } else if (FilterAPI.isFilterClassMode(subString)) {
            subscriptionData.setClassFilterMode(true);
        } else {
            String[] tags = subString.split("\\|\\|");
            if (tags != null && tags.length > 0) {
                for (String tag : tags) {
                    String trimString;
                    if (tag.length() <= 0 || (trimString = tag.trim()).length() <= 0) continue;
                    subscriptionData.getTagsSet().add(trimString);
                    subscriptionData.getCodeSet().add(trimString.hashCode());
                }
            } else {
                throw new Exception("subString split error");
            }
        }
        return subscriptionData;
    }
}

