/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.namesrv;

import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.help.FAQUrl;
import com.alibaba.rocketmq.common.utils.HttpTinyClient;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopAddressing {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private String nsAddr;
    private String wsAddr;

    public TopAddressing(String wsAddr) {
        this.wsAddr = wsAddr;
    }

    private static String clearNewLine(String str) {
        String newString = str.trim();
        int index = newString.indexOf("\r");
        if (index != -1) {
            return newString.substring(0, index);
        }
        index = newString.indexOf("\n");
        if (index != -1) {
            return newString.substring(0, index);
        }
        return newString;
    }

    public final String fetchNSAddr() {
        try {
            HttpTinyClient.HttpResult result = HttpTinyClient.httpGet(this.wsAddr, null, null, "UTF-8", 3000L);
            if (200 == result.code) {
                String responseStr = result.content;
                if (responseStr != null) {
                    return TopAddressing.clearNewLine(responseStr);
                }
                log.error("fetch nameserver address is null");
            } else {
                log.error("fetch nameserver address failed. statusCode={}", (Object)result.code);
            }
        }
        catch (IOException e) {
            log.error("fetchZKAddr exception", (Throwable)e);
        }
        String errorMsg = "connect to " + this.wsAddr + " failed, maybe the domain name " + MixAll.WS_DOMAIN_NAME + " not bind in /etc/hosts";
        errorMsg = errorMsg + FAQUrl.suggestTodo("https://github.com/alibaba/RocketMQ/issues/57");
        log.warn(errorMsg);
        System.out.println(errorMsg);
        return null;
    }

    public String getNsAddr() {
        return this.nsAddr;
    }

    public void setNsAddr(String nsAddr) {
        this.nsAddr = nsAddr;
    }
}

