/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.stats;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.stats.CallSnapshot;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class StatsItem {
    private final AtomicLong value = new AtomicLong(0L);
    private final AtomicLong times = new AtomicLong(0L);
    private final LinkedList<CallSnapshot> csListMinute = new LinkedList();
    private final LinkedList<CallSnapshot> csListHour = new LinkedList();
    private final LinkedList<CallSnapshot> csListDay = new LinkedList();
    private final String statsName;
    private final String statsKey;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Logger log;
    private volatile long sumInLastMinutes = 0L;
    private volatile double avgpsecondInLastMinutes = 0.0;
    private volatile double avgptimesInLastMinutes = 0.0;
    private volatile long sumInLastHour = 0L;
    private volatile long sumInLastDay = 0L;

    public StatsItem(String statsName, String statsKey, ScheduledExecutorService scheduledExecutorService, Logger log) {
        this.statsName = statsName;
        this.statsKey = statsKey;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItem.this.samplingInSeconds();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItem.this.samplingInMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItem.this.samplingInHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 1L, TimeUnit.HOURS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItem.this.printAtMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 60000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItem.this.printAtHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextHourTimeMillis() - System.currentTimeMillis()), 3600000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItem.this.printAtHalfHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextHalfHourTimeMillis() - System.currentTimeMillis()), 1800000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItem.this.printAtDay();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMorningTimeMillis() - System.currentTimeMillis()), 86400000L, TimeUnit.MILLISECONDS);
    }

    public void printAtMinutes() {
        double avgpsecond = 0.0;
        double avgptimes = 0.0;
        if (!this.csListMinute.isEmpty()) {
            CallSnapshot first = this.csListMinute.getFirst();
            CallSnapshot last = this.csListMinute.getLast();
            this.sumInLastMinutes = last.getValue() - first.getValue();
            this.avgpsecondInLastMinutes = avgpsecond = (double)this.sumInLastMinutes * 1000.0 / (double)(last.getTimestamp() - first.getTimestamp());
            long timesDiff = last.getTimes() - first.getTimes();
            if (timesDiff > 0L) {
                avgptimes = (double)this.sumInLastMinutes * 1.0 / (double)timesDiff;
            }
            this.avgptimesInLastMinutes = avgptimes;
        }
        this.log.info(String.format("[%s] [%s] Stats In One Minute, SUM: %d TPS: %.2f AVGPT: %.2f", this.statsName, this.statsKey, this.sumInLastMinutes, avgpsecond, avgptimes));
    }

    public void printAtHour() {
        double avgpsecond = 0.0;
        double avgptimes = 0.0;
        if (!this.csListHour.isEmpty()) {
            CallSnapshot first = this.csListHour.getFirst();
            CallSnapshot last = this.csListHour.getLast();
            this.sumInLastHour = last.getValue() - first.getValue();
            avgpsecond = (double)this.sumInLastHour * 1000.0 / (double)(last.getTimestamp() - first.getTimestamp());
            long timesDiff = last.getTimes() - first.getTimes();
            if (timesDiff > 0L) {
                avgptimes = (double)this.sumInLastHour * 1.0 / (double)timesDiff;
            }
        }
        this.log.info(String.format("[%s] [%s] Stats In One Hour, SUM: %d TPS: %.2f AVGPT: %.2f", this.statsName, this.statsKey, this.sumInLastHour, avgpsecond, avgptimes));
    }

    public void printAtHalfHour() {
        double avgpsecond = 0.0;
        double avgptimes = 0.0;
        long sumInLastHalfHour = 0L;
        if (!this.csListHour.isEmpty()) {
            CallSnapshot first = this.csListHour.get(3);
            if (null == first) {
                return;
            }
            CallSnapshot last = this.csListHour.getLast();
            sumInLastHalfHour = last.getValue() - first.getValue();
            avgpsecond = (double)sumInLastHalfHour * 1000.0 / (double)(last.getTimestamp() - first.getTimestamp());
            long timesDiff = last.getTimes() - first.getTimes();
            if (timesDiff > 0L) {
                avgptimes = (double)sumInLastHalfHour * 1.0 / (double)timesDiff;
            }
        }
        this.log.info(String.format("[%s] [%s] Stats In Half An Hour, SUM: %d TPS: %.2f AVGPT: %.2f", this.statsName, this.statsKey, sumInLastHalfHour, avgpsecond, avgptimes));
    }

    public void printAtDay() {
        double avgpsecond = 0.0;
        double avgptimes = 0.0;
        if (!this.csListDay.isEmpty()) {
            CallSnapshot first = this.csListDay.getFirst();
            CallSnapshot last = this.csListDay.getLast();
            this.sumInLastDay = last.getValue() - first.getValue();
            avgpsecond = (double)this.sumInLastDay * 1000.0 / (double)(last.getTimestamp() - first.getTimestamp());
            long timesDiff = last.getTimes() - first.getTimes();
            if (timesDiff > 0L) {
                avgptimes = (double)this.sumInLastDay * 1.0 / (double)timesDiff;
            }
        }
        this.log.info(String.format("[%s] [%s] Stats In One Day, SUM: %d TPS: %.2f AVGPT: %.2f", this.statsName, this.statsKey, this.sumInLastDay, avgpsecond, avgptimes));
    }

    public void samplingInSeconds() {
        this.csListMinute.add(new CallSnapshot(System.currentTimeMillis(), this.times.get(), this.value.get()));
        if (this.csListMinute.size() > 7) {
            this.csListMinute.removeFirst();
        }
    }

    public void samplingInMinutes() {
        this.csListHour.add(new CallSnapshot(System.currentTimeMillis(), this.times.get(), this.value.get()));
        if (this.csListHour.size() > 7) {
            this.csListHour.removeFirst();
        }
    }

    public void samplingInHour() {
        this.csListDay.add(new CallSnapshot(System.currentTimeMillis(), this.times.get(), this.value.get()));
        if (this.csListDay.size() > 25) {
            this.csListDay.removeFirst();
        }
    }

    public AtomicLong getValue() {
        return this.value;
    }

    public long getSumInLastMinutes() {
        return this.sumInLastMinutes;
    }

    public void setSumInLastMinutes(long sumInLastMinutes) {
        this.sumInLastMinutes = sumInLastMinutes;
    }

    public long getSumInLastHour() {
        return this.sumInLastHour;
    }

    public void setSumInLastHour(long sumInLastHour) {
        this.sumInLastHour = sumInLastHour;
    }

    public long getSumInLastDay() {
        return this.sumInLastDay;
    }

    public void setSumInLastDay(long sumInLastDay) {
        this.sumInLastDay = sumInLastDay;
    }

    public String getStatsKey() {
        return this.statsKey;
    }

    public String getStatsName() {
        return this.statsName;
    }

    public AtomicLong getTimes() {
        return this.times;
    }

    public double getAvgptimesInLastMinutes() {
        return this.avgptimesInLastMinutes;
    }

    public void setAvgptimesInLastMinutes(double avgptimesInLastMinutes) {
        this.avgptimesInLastMinutes = avgptimesInLastMinutes;
    }

    public double getAvgpsecondInLastMinutes() {
        return this.avgpsecondInLastMinutes;
    }

    public void setAvgpsecondInLastMinutes(double avgpsecondInLastMinutes) {
        this.avgpsecondInLastMinutes = avgpsecondInLastMinutes;
    }
}

