/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.stats;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.stats.StatsItem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class StatsItemSet {
    private final ConcurrentHashMap<String, StatsItem> statsItemTable = new ConcurrentHashMap(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Logger log;

    public StatsItemSet(String statsName, ScheduledExecutorService scheduledExecutorService, Logger log) {
        this.statsName = statsName;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
        this.init();
    }

    private StatsItem getAndCreateStatsItem(String statsKey) {
        StatsItem prev;
        StatsItem statsItem = this.statsItemTable.get(statsKey);
        if (null != statsItem || null == (prev = this.statsItemTable.put(statsKey, statsItem = new StatsItem(this.statsName, statsKey, this.scheduledExecutorService, this.log)))) {
            // empty if block
        }
        return statsItem;
    }

    public void addValue(String statsKey, int incValue, int incTimes) {
        StatsItem statsItem = this.getAndCreateStatsItem(statsKey);
        statsItem.getValue().addAndGet(incValue);
        statsItem.getTimes().addAndGet(incTimes);
    }

    public long getSumInLastMinutes(String statsKey) {
        StatsItem statsItem = this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getSumInLastMinutes();
        }
        return 0L;
    }

    public double getAvgpsInLastMinutes(String statsKey) {
        StatsItem statsItem = this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getAvgpsecondInLastMinutes();
        }
        return 0.0;
    }

    public long getSumInLastHour(String statsKey) {
        StatsItem statsItem = this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getSumInLastHour();
        }
        return 0L;
    }

    public long getSumInLastDay(String statsKey) {
        StatsItem statsItem = this.statsItemTable.get(statsKey);
        if (null != statsItem) {
            return statsItem.getSumInLastDay();
        }
        return 0L;
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInSeconds();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.samplingInHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 1L, TimeUnit.HOURS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 60000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextHourTimeMillis() - System.currentTimeMillis()), 3600000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtHalfHour();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextHalfHourTimeMillis() - System.currentTimeMillis()), 1800000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatsItemSet.this.printAtDay();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMorningTimeMillis() - System.currentTimeMillis()), 86400000L, TimeUnit.MILLISECONDS);
    }

    private void printAtMinutes() {
        for (Map.Entry<String, StatsItem> next : this.statsItemTable.entrySet()) {
            next.getValue().printAtMinutes();
        }
    }

    private void printAtHour() {
        for (Map.Entry<String, StatsItem> next : this.statsItemTable.entrySet()) {
            next.getValue().printAtHour();
        }
    }

    private void printAtHalfHour() {
        for (Map.Entry<String, StatsItem> next : this.statsItemTable.entrySet()) {
            next.getValue().printAtHalfHour();
        }
    }

    private void printAtDay() {
        for (Map.Entry<String, StatsItem> next : this.statsItemTable.entrySet()) {
            next.getValue().printAtDay();
        }
    }

    private void samplingInSeconds() {
        for (Map.Entry<String, StatsItem> next : this.statsItemTable.entrySet()) {
            next.getValue().samplingInSeconds();
        }
    }

    private void samplingInMinutes() {
        for (Map.Entry<String, StatsItem> next : this.statsItemTable.entrySet()) {
            next.getValue().samplingInMinutes();
        }
    }

    private void samplingInHour() {
        for (Map.Entry<String, StatsItem> next : this.statsItemTable.entrySet()) {
            next.getValue().samplingInHour();
        }
    }
}

