/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store;

import com.alibaba.rocketmq.common.ServiceThread;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.store.MapedFile;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocateMapedFileService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static int WaitTimeOut = 5000;
    private ConcurrentHashMap<String, AllocateRequest> requestTable = new ConcurrentHashMap();
    private PriorityBlockingQueue<AllocateRequest> requestQueue = new PriorityBlockingQueue();
    private volatile boolean hasException = false;

    public MapedFile putRequestAndReturnMapedFile(String nextFilePath, String nextNextFilePath, int fileSize) {
        boolean offerOK;
        boolean nextNextPutOK;
        AllocateRequest nextReq = new AllocateRequest(nextFilePath, fileSize);
        AllocateRequest nextNextReq = new AllocateRequest(nextNextFilePath, fileSize);
        boolean nextPutOK = this.requestTable.putIfAbsent(nextFilePath, nextReq) == null;
        boolean bl = nextNextPutOK = this.requestTable.putIfAbsent(nextNextFilePath, nextNextReq) == null;
        if (nextPutOK && !(offerOK = this.requestQueue.offer(nextReq))) {
            log.warn("add a request to preallocate queue failed");
        }
        if (nextNextPutOK && !(offerOK = this.requestQueue.offer(nextNextReq))) {
            log.warn("add a request to preallocate queue failed");
        }
        if (this.hasException) {
            log.warn(this.getServiceName() + " service has exception. so return null");
            return null;
        }
        AllocateRequest result = this.requestTable.get(nextFilePath);
        try {
            if (result != null) {
                boolean waitOK = result.getCountDownLatch().await(WaitTimeOut, TimeUnit.MILLISECONDS);
                if (!waitOK) {
                    log.warn("create mmap timeout " + result.getFilePath() + " " + result.getFileSize());
                }
                this.requestTable.remove(nextFilePath);
                return result.getMapedFile();
            }
            log.error("find preallocate mmap failed, this never happen");
        }
        catch (InterruptedException e) {
            log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
        }
        return null;
    }

    public String getServiceName() {
        return AllocateMapedFileService.class.getSimpleName();
    }

    public void shutdown() {
        this.stoped = true;
        this.thread.interrupt();
        try {
            this.thread.join(this.getJointime());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (AllocateRequest req : this.requestTable.values()) {
            if (req.mapedFile == null) continue;
            log.info("delete pre allocated maped file, {}", (Object)req.mapedFile.getFileName());
            req.mapedFile.destroy(1000L);
        }
    }

    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStoped() && this.mmapOperation()) {
        }
        log.info(this.getServiceName() + " service end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mmapOperation() {
        AllocateRequest req = null;
        try {
            req = this.requestQueue.take();
            if (null == this.requestTable.get(req.getFilePath())) {
                log.warn("this mmap request expired, maybe cause timeout " + req.getFilePath() + " " + req.getFileSize());
                boolean bl = true;
                return bl;
            }
            if (req.getMapedFile() == null) {
                long beginTime = System.currentTimeMillis();
                MapedFile mapedFile = new MapedFile(req.getFilePath(), req.getFileSize());
                long eclipseTime = UtilAll.computeEclipseTimeMilliseconds((long)beginTime);
                if (eclipseTime > 10L) {
                    int queueSize = this.requestQueue.size();
                    log.warn("create mapedFile spent time(ms) " + eclipseTime + " queue size " + queueSize + " " + req.getFilePath() + " " + req.getFileSize());
                }
                req.setMapedFile(mapedFile);
                this.hasException = false;
            }
        }
        catch (InterruptedException e) {
            log.warn(this.getServiceName() + " service has exception, maybe by shutdown");
            this.hasException = true;
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            this.hasException = true;
        }
        finally {
            if (req != null) {
                req.getCountDownLatch().countDown();
            }
        }
        return true;
    }

    class AllocateRequest
    implements Comparable<AllocateRequest> {
        private String filePath;
        private int fileSize;
        private CountDownLatch countDownLatch = new CountDownLatch(1);
        private volatile MapedFile mapedFile = null;

        public AllocateRequest(String filePath, int fileSize) {
            this.filePath = filePath;
            this.fileSize = fileSize;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(int fileSize) {
            this.fileSize = fileSize;
        }

        public CountDownLatch getCountDownLatch() {
            return this.countDownLatch;
        }

        public void setCountDownLatch(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public MapedFile getMapedFile() {
            return this.mapedFile;
        }

        public void setMapedFile(MapedFile mapedFile) {
            this.mapedFile = mapedFile;
        }

        @Override
        public int compareTo(AllocateRequest other) {
            return this.fileSize < other.fileSize ? 1 : (this.fileSize > other.fileSize ? -1 : 0);
        }
    }
}

