/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store;

import com.alibaba.rocketmq.store.DefaultMessageStore;
import com.alibaba.rocketmq.store.MapedFile;
import com.alibaba.rocketmq.store.MapedFileQueue;
import com.alibaba.rocketmq.store.SelectMapedBufferResult;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeQueue {
    public static final int CQStoreUnitSize = 20;
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private final DefaultMessageStore defaultMessageStore;
    private final MapedFileQueue mapedFileQueue;
    private final String topic;
    private final int queueId;
    private final ByteBuffer byteBufferIndex;
    private final String storePath;
    private final int mapedFileSize;
    private long maxPhysicOffset = -1L;
    private volatile long minLogicOffset = 0L;

    public ConsumeQueue(String topic, int queueId, String storePath, int mapedFileSize, DefaultMessageStore defaultMessageStore) {
        this.storePath = storePath;
        this.mapedFileSize = mapedFileSize;
        this.defaultMessageStore = defaultMessageStore;
        this.topic = topic;
        this.queueId = queueId;
        String queueDir = this.storePath + File.separator + topic + File.separator + queueId;
        this.mapedFileQueue = new MapedFileQueue(queueDir, mapedFileSize, null);
        this.byteBufferIndex = ByteBuffer.allocate(20);
    }

    public boolean load() {
        boolean result = this.mapedFileQueue.load();
        log.info("load consume queue " + this.topic + "-" + this.queueId + " " + (result ? "OK" : "Failed"));
        return result;
    }

    public void recover() {
        List<MapedFile> mapedFiles = this.mapedFileQueue.getMapedFiles();
        if (!mapedFiles.isEmpty()) {
            long mapedFileOffset;
            block6: {
                int index = mapedFiles.size() - 3;
                if (index < 0) {
                    index = 0;
                }
                int mapedFileSizeLogics = this.mapedFileSize;
                MapedFile mapedFile = mapedFiles.get(index);
                ByteBuffer byteBuffer = mapedFile.sliceByteBuffer();
                long processOffset = mapedFile.getFileFromOffset();
                mapedFileOffset = 0L;
                while (true) {
                    for (int i = 0; i < mapedFileSizeLogics; i += 20) {
                        long offset = byteBuffer.getLong();
                        int size = byteBuffer.getInt();
                        long tagsCode = byteBuffer.getLong();
                        if (offset < 0L || size <= 0) {
                            log.info("recover current consume queue file over,  " + mapedFile.getFileName() + " " + offset + " " + size + " " + tagsCode);
                            break;
                        }
                        mapedFileOffset = i + 20;
                        this.maxPhysicOffset = offset;
                    }
                    if (mapedFileOffset != (long)mapedFileSizeLogics) break;
                    if (++index >= mapedFiles.size()) {
                        log.info("recover last consume queue file over, last maped file " + mapedFile.getFileName());
                        break block6;
                    }
                    mapedFile = mapedFiles.get(index);
                    byteBuffer = mapedFile.sliceByteBuffer();
                    processOffset = mapedFile.getFileFromOffset();
                    mapedFileOffset = 0L;
                    log.info("recover next consume queue file, " + mapedFile.getFileName());
                }
                log.info("recover current consume queue queue over " + mapedFile.getFileName() + " " + (processOffset + mapedFileOffset));
            }
            this.mapedFileQueue.truncateDirtyFiles(processOffset += mapedFileOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOffsetInQueueByTime(long timestamp) {
        MapedFile mapedFile = this.mapedFileQueue.getMapedFileByTime(timestamp);
        if (mapedFile != null) {
            long offset = 0L;
            int low = this.minLogicOffset > mapedFile.getFileFromOffset() ? (int)(this.minLogicOffset - mapedFile.getFileFromOffset()) : 0;
            int high = 0;
            int midOffset = -1;
            int targetOffset = -1;
            int leftOffset = -1;
            int rightOffset = -1;
            long leftIndexValue = -1L;
            long rightIndexValue = -1L;
            SelectMapedBufferResult sbr = mapedFile.selectMapedBuffer(0);
            if (null != sbr) {
                ByteBuffer byteBuffer = sbr.getByteBuffer();
                high = byteBuffer.limit() - 20;
                try {
                    while (high >= low) {
                        midOffset = (low + high) / 40 * 20;
                        byteBuffer.position(midOffset);
                        long phyOffset = byteBuffer.getLong();
                        int size = byteBuffer.getInt();
                        long storeTime = this.defaultMessageStore.getCommitLog().pickupStoretimestamp(phyOffset, size);
                        if (storeTime < 0L) {
                            long l = 0L;
                            return l;
                        }
                        if (storeTime == timestamp) {
                            targetOffset = midOffset;
                            break;
                        }
                        if (storeTime > timestamp) {
                            high = midOffset - 20;
                            rightOffset = midOffset;
                            rightIndexValue = storeTime;
                            continue;
                        }
                        low = midOffset + 20;
                        leftOffset = midOffset;
                        leftIndexValue = storeTime;
                    }
                    offset = targetOffset != -1 ? (long)targetOffset : (leftIndexValue == -1L ? (long)rightOffset : (rightIndexValue == -1L ? (long)leftOffset : (Math.abs(timestamp - leftIndexValue) > Math.abs(timestamp - rightIndexValue) ? (long)rightOffset : (long)leftOffset)));
                    long l = (mapedFile.getFileFromOffset() + offset) / 20L;
                    return l;
                }
                finally {
                    sbr.release();
                }
            }
        }
        return 0L;
    }

    public void truncateDirtyLogicFiles(long phyOffet) {
        MapedFile mapedFile;
        int logicFileSize = this.mapedFileSize;
        this.maxPhysicOffset = phyOffet - 1L;
        block0: while ((mapedFile = this.mapedFileQueue.getLastMapedFile2()) != null) {
            ByteBuffer byteBuffer = mapedFile.sliceByteBuffer();
            mapedFile.setWrotePostion(0);
            mapedFile.setCommittedPosition(0);
            for (int i = 0; i < logicFileSize; i += 20) {
                int pos;
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                byteBuffer.getLong();
                if (0 == i) {
                    if (offset >= phyOffet) {
                        this.mapedFileQueue.deleteLastMapedFile();
                        continue block0;
                    }
                    pos = i + 20;
                    mapedFile.setWrotePostion(pos);
                    mapedFile.setCommittedPosition(pos);
                    this.maxPhysicOffset = offset;
                    continue;
                }
                if (offset >= 0L && size > 0) {
                    if (offset >= phyOffet) {
                        return;
                    }
                    pos = i + 20;
                    mapedFile.setWrotePostion(pos);
                    mapedFile.setCommittedPosition(pos);
                    this.maxPhysicOffset = offset;
                    if (pos != logicFileSize) continue;
                    return;
                }
                return;
            }
        }
    }

    public long getLastOffset() {
        long lastOffset = -1L;
        int logicFileSize = this.mapedFileSize;
        MapedFile mapedFile = this.mapedFileQueue.getLastMapedFile2();
        if (mapedFile != null) {
            int position = mapedFile.getWrotePostion() - 20;
            if (position < 0) {
                position = 0;
            }
            ByteBuffer byteBuffer = mapedFile.sliceByteBuffer();
            byteBuffer.position(position);
            for (int i = 0; i < logicFileSize; i += 20) {
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                byteBuffer.getLong();
                if (offset < 0L || size <= 0) break;
                lastOffset = offset + (long)size;
            }
        }
        return lastOffset;
    }

    public boolean commit(int flushLeastPages) {
        return this.mapedFileQueue.commit(flushLeastPages);
    }

    public int deleteExpiredFile(long offset) {
        int cnt = this.mapedFileQueue.deleteExpiredFileByOffset(offset, 20);
        this.correctMinOffset(offset);
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correctMinOffset(long phyMinOffset) {
        SelectMapedBufferResult result;
        MapedFile mapedFile = this.mapedFileQueue.getFirstMapedFileOnLock();
        if (mapedFile != null && (result = mapedFile.selectMapedBuffer(0)) != null) {
            try {
                for (int i = 0; i < result.getSize(); i += 20) {
                    long offsetPy = result.getByteBuffer().getLong();
                    result.getByteBuffer().getInt();
                    result.getByteBuffer().getLong();
                    if (offsetPy < phyMinOffset) continue;
                    this.minLogicOffset = result.getMapedFile().getFileFromOffset() + (long)i;
                    log.info("compute logics min offset: " + this.getMinOffsetInQuque() + ", topic: " + this.topic + ", queueId: " + this.queueId);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                result.release();
            }
        }
    }

    public long getMinOffsetInQuque() {
        return this.minLogicOffset / 20L;
    }

    public void putMessagePostionInfoWrapper(long offset, int size, long tagsCode, long storeTimestamp, long logicOffset) {
        int MaxRetries = 5;
        boolean canWrite = this.defaultMessageStore.getRunningFlags().isWriteable();
        for (int i = 0; i < 5 && canWrite; ++i) {
            boolean result = this.putMessagePostionInfo(offset, size, tagsCode, logicOffset);
            if (result) {
                this.defaultMessageStore.getStoreCheckpoint().setLogicsMsgTimestamp(storeTimestamp);
                return;
            }
            log.warn("[BUG]put commit log postion info to " + this.topic + ":" + this.queueId + " " + offset + " failed, retry " + i + " times");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("", (Throwable)e);
            }
        }
        log.error("[BUG]consume queue can not write, {} {}", (Object)this.topic, (Object)this.queueId);
        this.defaultMessageStore.getRunningFlags().makeLogicsQueueError();
    }

    private boolean putMessagePostionInfo(long offset, int size, long tagsCode, long cqOffset) {
        if (offset <= this.maxPhysicOffset) {
            return true;
        }
        this.byteBufferIndex.flip();
        this.byteBufferIndex.limit(20);
        this.byteBufferIndex.putLong(offset);
        this.byteBufferIndex.putInt(size);
        this.byteBufferIndex.putLong(tagsCode);
        long expectLogicOffset = cqOffset * 20L;
        MapedFile mapedFile = this.mapedFileQueue.getLastMapedFile(expectLogicOffset);
        if (mapedFile != null) {
            long currentLogicOffset;
            if (mapedFile.isFirstCreateInQueue() && cqOffset != 0L && mapedFile.getWrotePostion() == 0) {
                this.minLogicOffset = expectLogicOffset;
                this.fillPreBlank(mapedFile, expectLogicOffset);
                log.info("fill pre blank space " + mapedFile.getFileName() + " " + expectLogicOffset + " " + mapedFile.getWrotePostion());
            }
            if (cqOffset != 0L && expectLogicOffset != (currentLogicOffset = (long)mapedFile.getWrotePostion() + mapedFile.getFileFromOffset())) {
                logError.warn("[BUG]logic queue order maybe wrong, expectLogicOffset: {} currentLogicOffset: {} Topic: {} QID: {} Diff: {}", new Object[]{expectLogicOffset, currentLogicOffset, this.topic, this.queueId, expectLogicOffset - currentLogicOffset});
            }
            this.maxPhysicOffset = offset;
            return mapedFile.appendMessage(this.byteBufferIndex.array());
        }
        return false;
    }

    private void fillPreBlank(MapedFile mapedFile, long untilWhere) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putLong(0L);
        byteBuffer.putInt(Integer.MAX_VALUE);
        byteBuffer.putLong(0L);
        int until = (int)(untilWhere % (long)this.mapedFileQueue.getMapedFileSize());
        for (int i = 0; i < until; i += 20) {
            mapedFile.appendMessage(byteBuffer.array());
        }
    }

    public SelectMapedBufferResult getIndexBuffer(long startIndex) {
        MapedFile mapedFile;
        int mapedFileSize = this.mapedFileSize;
        long offset = startIndex * 20L;
        if (offset >= this.getMinLogicOffset() && (mapedFile = this.mapedFileQueue.findMapedFileByOffset(offset)) != null) {
            SelectMapedBufferResult result = mapedFile.selectMapedBuffer((int)(offset % (long)mapedFileSize));
            return result;
        }
        return null;
    }

    public long rollNextFile(long index) {
        int mapedFileSize = this.mapedFileSize;
        int totalUnitsInFile = mapedFileSize / 20;
        return index + (long)totalUnitsInFile - index % (long)totalUnitsInFile;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public long getMaxPhysicOffset() {
        return this.maxPhysicOffset;
    }

    public void setMaxPhysicOffset(long maxPhysicOffset) {
        this.maxPhysicOffset = maxPhysicOffset;
    }

    public void destroy() {
        this.maxPhysicOffset = -1L;
        this.minLogicOffset = 0L;
        this.mapedFileQueue.destroy();
    }

    public long getMinLogicOffset() {
        return this.minLogicOffset;
    }

    public void setMinLogicOffset(long minLogicOffset) {
        this.minLogicOffset = minLogicOffset;
    }

    public long getMessageTotalInQueue() {
        return this.getMaxOffsetInQuque() - this.getMinOffsetInQuque();
    }

    public long getMaxOffsetInQuque() {
        return this.mapedFileQueue.getMaxOffset() / 20L;
    }
}

