/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store;

import com.alibaba.rocketmq.store.MapedFile;
import java.nio.ByteBuffer;

public class SelectMapedBufferResult {
    private final long startOffset;
    private final ByteBuffer byteBuffer;
    private int size;
    private MapedFile mapedFile;

    public SelectMapedBufferResult(long startOffset, ByteBuffer byteBuffer, int size, MapedFile mapedFile) {
        this.startOffset = startOffset;
        this.byteBuffer = byteBuffer;
        this.size = size;
        this.mapedFile = mapedFile;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int s) {
        this.size = s;
        this.byteBuffer.limit(this.size);
    }

    public MapedFile getMapedFile() {
        return this.mapedFile;
    }

    protected void finalize() {
        if (this.mapedFile != null) {
            this.release();
        }
    }

    public synchronized void release() {
        if (this.mapedFile != null) {
            this.mapedFile.release();
            this.mapedFile = null;
        }
    }

    public long getStartOffset() {
        return this.startOffset;
    }
}

