/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store;

import com.alibaba.rocketmq.common.ServiceThread;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreStatsService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final int FrequencyOfSampling = 1000;
    private static final int MaxRecordsOfSampling = 600;
    private static int PrintTPSInterval = 60;
    private final AtomicLong putMessageFailedTimes = new AtomicLong(0L);
    private final Map<String, AtomicLong> putMessageTopicTimesTotal = new ConcurrentHashMap<String, AtomicLong>(128);
    private final Map<String, AtomicLong> putMessageTopicSizeTotal = new ConcurrentHashMap<String, AtomicLong>(128);
    private final AtomicLong getMessageTimesTotalFound = new AtomicLong(0L);
    private final AtomicLong getMessageTransferedMsgCount = new AtomicLong(0L);
    private final AtomicLong getMessageTimesTotalMiss = new AtomicLong(0L);
    private final AtomicLong[] putMessageDistributeTime = new AtomicLong[7];
    private final LinkedList<CallSnapshot> putTimesList = new LinkedList();
    private final LinkedList<CallSnapshot> getTimesFoundList = new LinkedList();
    private final LinkedList<CallSnapshot> getTimesMissList = new LinkedList();
    private final LinkedList<CallSnapshot> transferedMsgCountList = new LinkedList();
    private long messageStoreBootTimestamp = System.currentTimeMillis();
    private volatile long putMessageEntireTimeMax = 0L;
    private volatile long getMessageEntireTimeMax = 0L;
    private ReentrantLock lockPut = new ReentrantLock();
    private ReentrantLock lockGet = new ReentrantLock();
    private volatile long dispatchMaxBuffer = 0L;
    private ReentrantLock lockSampling = new ReentrantLock();
    private long lastPrintTimestamp = System.currentTimeMillis();

    public StoreStatsService() {
        for (int i = 0; i < this.putMessageDistributeTime.length; ++i) {
            this.putMessageDistributeTime[i] = new AtomicLong(0L);
        }
    }

    public long getPutMessageEntireTimeMax() {
        return this.putMessageEntireTimeMax;
    }

    public void setPutMessageEntireTimeMax(long value) {
        if (value <= 0L) {
            this.putMessageDistributeTime[0].incrementAndGet();
        } else if (value < 10L) {
            this.putMessageDistributeTime[1].incrementAndGet();
        } else if (value < 100L) {
            this.putMessageDistributeTime[2].incrementAndGet();
        } else if (value < 500L) {
            this.putMessageDistributeTime[3].incrementAndGet();
        } else if (value < 1000L) {
            this.putMessageDistributeTime[4].incrementAndGet();
        } else if (value < 10000L) {
            this.putMessageDistributeTime[5].incrementAndGet();
        } else {
            this.putMessageDistributeTime[6].incrementAndGet();
        }
        if (value > this.putMessageEntireTimeMax) {
            this.lockPut.lock();
            this.putMessageEntireTimeMax = value > this.putMessageEntireTimeMax ? value : this.putMessageEntireTimeMax;
            this.lockPut.unlock();
        }
    }

    public long getGetMessageEntireTimeMax() {
        return this.getMessageEntireTimeMax;
    }

    public void setGetMessageEntireTimeMax(long value) {
        if (value > this.getMessageEntireTimeMax) {
            this.lockGet.lock();
            this.getMessageEntireTimeMax = value > this.getMessageEntireTimeMax ? value : this.getMessageEntireTimeMax;
            this.lockGet.unlock();
        }
    }

    public long getDispatchMaxBuffer() {
        return this.dispatchMaxBuffer;
    }

    public void setDispatchMaxBuffer(long value) {
        this.dispatchMaxBuffer = value > this.dispatchMaxBuffer ? value : this.dispatchMaxBuffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        Long totalTimes = this.getPutMessageTimesTotal();
        if (0L == totalTimes) {
            totalTimes = 1L;
        }
        sb.append("\truntime: " + this.getFormatRuntime() + "\r\n");
        sb.append("\tputMessageEntireTimeMax: " + this.putMessageEntireTimeMax + "\r\n");
        sb.append("\tputMessageTimesTotal: " + totalTimes + "\r\n");
        sb.append("\tputMessageSizeTotal: " + this.getPutMessageSizeTotal() + "\r\n");
        sb.append("\tputMessageDistributeTime: " + this.getPutMessageDistributeTimeStringInfo(totalTimes) + "\r\n");
        sb.append("\tputMessageAverageSize: " + (double)this.getPutMessageSizeTotal() / totalTimes.doubleValue() + "\r\n");
        sb.append("\tdispatchMaxBuffer: " + this.dispatchMaxBuffer + "\r\n");
        sb.append("\tgetMessageEntireTimeMax: " + this.getMessageEntireTimeMax + "\r\n");
        sb.append("\tputTps: " + this.getPutTps() + "\r\n");
        sb.append("\tgetFoundTps: " + this.getGetFoundTps() + "\r\n");
        sb.append("\tgetMissTps: " + this.getGetMissTps() + "\r\n");
        sb.append("\tgetTotalTps: " + this.getGetTotalTps() + "\r\n");
        sb.append("\tgetTransferedTps: " + this.getGetTransferedTps() + "\r\n");
        return sb.toString();
    }

    private String getPutMessageDistributeTimeStringInfo(Long total) {
        StringBuilder sb = new StringBuilder(512);
        for (AtomicLong i : this.putMessageDistributeTime) {
            long value = i.get();
            double ratio = (double)value / total.doubleValue();
            sb.append("\r\n\t\t");
            sb.append(value + "(" + ratio * 100.0 + "%)");
        }
        return sb.toString();
    }

    private String getFormatRuntime() {
        long MILLISECOND = 1L;
        long SECOND = 1000L;
        long MINUTE = 60000L;
        long HOUR = 3600000L;
        long DAY = 86400000L;
        MessageFormat TIME = new MessageFormat("[ {0} days, {1} hours, {2} minutes, {3} seconds ]");
        long time = System.currentTimeMillis() - this.messageStoreBootTimestamp;
        long days = time / 86400000L;
        long hours = time % 86400000L / 3600000L;
        long minutes = time % 3600000L / 60000L;
        long seconds = time % 60000L / 1000L;
        return TIME.format(new Long[]{days, hours, minutes, seconds});
    }

    private String getPutTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPutTps(10));
        sb.append(" ");
        sb.append(this.getPutTps(60));
        sb.append(" ");
        sb.append(this.getPutTps(600));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPutTps(int time) {
        String result = "";
        this.lockSampling.lock();
        try {
            CallSnapshot last = this.putTimesList.getLast();
            if (this.putTimesList.size() > time) {
                CallSnapshot lastBefore = this.putTimesList.get(this.putTimesList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return result;
    }

    private String getGetFoundTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetFoundTps(10));
        sb.append(" ");
        sb.append(this.getGetFoundTps(60));
        sb.append(" ");
        sb.append(this.getGetFoundTps(600));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetFoundTps(int time) {
        String result = "";
        this.lockSampling.lock();
        try {
            CallSnapshot last = this.getTimesFoundList.getLast();
            if (this.getTimesFoundList.size() > time) {
                CallSnapshot lastBefore = this.getTimesFoundList.get(this.getTimesFoundList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return result;
    }

    private String getGetMissTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetMissTps(10));
        sb.append(" ");
        sb.append(this.getGetMissTps(60));
        sb.append(" ");
        sb.append(this.getGetMissTps(600));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetMissTps(int time) {
        String result = "";
        this.lockSampling.lock();
        try {
            CallSnapshot last = this.getTimesMissList.getLast();
            if (this.getTimesMissList.size() > time) {
                CallSnapshot lastBefore = this.getTimesMissList.get(this.getTimesMissList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return result;
    }

    private String getGetTransferedTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetTransferedTps(10));
        sb.append(" ");
        sb.append(this.getGetTransferedTps(60));
        sb.append(" ");
        sb.append(this.getGetTransferedTps(600));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetTransferedTps(int time) {
        String result = "";
        this.lockSampling.lock();
        try {
            CallSnapshot last = this.transferedMsgCountList.getLast();
            if (this.transferedMsgCountList.size() > time) {
                CallSnapshot lastBefore = this.transferedMsgCountList.get(this.transferedMsgCountList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return result;
    }

    private String getGetTotalTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetTotalTps(10));
        sb.append(" ");
        sb.append(this.getGetTotalTps(60));
        sb.append(" ");
        sb.append(this.getGetTotalTps(600));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetTotalTps(int time) {
        this.lockSampling.lock();
        double found = 0.0;
        double miss = 0.0;
        try {
            CallSnapshot lastBefore;
            CallSnapshot last = this.getTimesFoundList.getLast();
            if (this.getTimesFoundList.size() > time) {
                lastBefore = this.getTimesFoundList.get(this.getTimesFoundList.size() - (time + 1));
                found = CallSnapshot.getTPS(lastBefore, last);
            }
            last = this.getTimesMissList.getLast();
            if (this.getTimesMissList.size() > time) {
                lastBefore = this.getTimesMissList.get(this.getTimesMissList.size() - (time + 1));
                miss = CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return Double.toString(found + miss);
    }

    public long getPutMessageTimesTotal() {
        long rs = 0L;
        for (AtomicLong data : this.putMessageTopicTimesTotal.values()) {
            rs += data.get();
        }
        return rs;
    }

    public long getPutMessageSizeTotal() {
        long rs = 0L;
        for (AtomicLong data : this.putMessageTopicSizeTotal.values()) {
            rs += data.get();
        }
        return rs;
    }

    public HashMap<String, String> getRuntimeInfo() {
        HashMap<String, String> result = new HashMap<String, String>(64);
        Long totalTimes = this.getPutMessageTimesTotal();
        if (0L == totalTimes) {
            totalTimes = 1L;
        }
        result.put("bootTimestamp", String.valueOf(this.messageStoreBootTimestamp));
        result.put("runtime", this.getFormatRuntime());
        result.put("putMessageEntireTimeMax", String.valueOf(this.putMessageEntireTimeMax));
        result.put("putMessageTimesTotal", String.valueOf(totalTimes));
        result.put("putMessageSizeTotal", String.valueOf(this.getPutMessageSizeTotal()));
        result.put("putMessageDistributeTime", String.valueOf(this.getPutMessageDistributeTimeStringInfo(totalTimes)));
        result.put("putMessageAverageSize", String.valueOf((double)this.getPutMessageSizeTotal() / totalTimes.doubleValue()));
        result.put("dispatchMaxBuffer", String.valueOf(this.dispatchMaxBuffer));
        result.put("getMessageEntireTimeMax", String.valueOf(this.getMessageEntireTimeMax));
        result.put("putTps", String.valueOf(this.getPutTps()));
        result.put("getFoundTps", String.valueOf(this.getGetFoundTps()));
        result.put("getMissTps", String.valueOf(this.getGetMissTps()));
        result.put("getTotalTps", String.valueOf(this.getGetTotalTps()));
        result.put("getTransferedTps", String.valueOf(this.getGetTransferedTps()));
        return result;
    }

    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStoped()) {
            try {
                this.waitForRunning(1000L);
                this.sampling();
                this.printTps();
            }
            catch (Exception e) {
                log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampling() {
        this.lockSampling.lock();
        try {
            this.putTimesList.add(new CallSnapshot(System.currentTimeMillis(), this.getPutMessageTimesTotal()));
            if (this.putTimesList.size() > 601) {
                this.putTimesList.removeFirst();
            }
            this.getTimesFoundList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTimesTotalFound.get()));
            if (this.getTimesFoundList.size() > 601) {
                this.getTimesFoundList.removeFirst();
            }
            this.getTimesMissList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTimesTotalMiss.get()));
            if (this.getTimesMissList.size() > 601) {
                this.getTimesMissList.removeFirst();
            }
            this.transferedMsgCountList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTransferedMsgCount.get()));
            if (this.transferedMsgCountList.size() > 601) {
                this.transferedMsgCountList.removeFirst();
            }
        }
        finally {
            this.lockSampling.unlock();
        }
    }

    private void printTps() {
        if (System.currentTimeMillis() > this.lastPrintTimestamp + (long)(PrintTPSInterval * 1000)) {
            this.lastPrintTimestamp = System.currentTimeMillis();
            log.info("put_tps {}", (Object)this.getPutTps(PrintTPSInterval));
            log.info("get_found_tps {}", (Object)this.getGetFoundTps(PrintTPSInterval));
            log.info("get_miss_tps {}", (Object)this.getGetMissTps(PrintTPSInterval));
            log.info("get_transfered_tps {}", (Object)this.getGetTransferedTps(PrintTPSInterval));
        }
    }

    public String getServiceName() {
        return StoreStatsService.class.getSimpleName();
    }

    public AtomicLong getGetMessageTimesTotalFound() {
        return this.getMessageTimesTotalFound;
    }

    public AtomicLong getGetMessageTimesTotalMiss() {
        return this.getMessageTimesTotalMiss;
    }

    public AtomicLong getGetMessageTransferedMsgCount() {
        return this.getMessageTransferedMsgCount;
    }

    public AtomicLong getPutMessageFailedTimes() {
        return this.putMessageFailedTimes;
    }

    public AtomicLong getSinglePutMessageTopicSizeTotal(String topic) {
        AtomicLong rs = this.putMessageTopicSizeTotal.get(topic);
        if (null == rs) {
            rs = new AtomicLong(0L);
            this.putMessageTopicSizeTotal.put(topic, rs);
        }
        return rs;
    }

    public AtomicLong getSinglePutMessageTopicTimesTotal(String topic) {
        AtomicLong rs = this.putMessageTopicTimesTotal.get(topic);
        if (null == rs) {
            rs = new AtomicLong(0L);
            this.putMessageTopicTimesTotal.put(topic, rs);
        }
        return rs;
    }

    public Map<String, AtomicLong> getPutMessageTopicTimesTotal() {
        return this.putMessageTopicTimesTotal;
    }

    public Map<String, AtomicLong> getPutMessageTopicSizeTotal() {
        return this.putMessageTopicSizeTotal;
    }

    static class CallSnapshot {
        public final long timestamp;
        public final long callTimesTotal;

        public CallSnapshot(long timestamp, long callTimesTotal) {
            this.timestamp = timestamp;
            this.callTimesTotal = callTimesTotal;
        }

        public static double getTPS(CallSnapshot begin, CallSnapshot end) {
            long total = end.callTimesTotal - begin.callTimesTotal;
            Long time = end.timestamp - begin.timestamp;
            double tps = (double)total / time.doubleValue();
            return tps * 1000.0;
        }
    }
}

