/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store.index;

import com.alibaba.rocketmq.store.MapedFile;
import com.alibaba.rocketmq.store.index.IndexHeader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFile {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static int HASH_SLOT_SIZE = 4;
    private static int INDEX_SIZE = 20;
    private static int INVALID_INDEX = 0;
    private final int hashSlotNum;
    private final int indexNum;
    private final MapedFile mapedFile;
    private final FileChannel fileChannel;
    private final MappedByteBuffer mappedByteBuffer;
    private final IndexHeader indexHeader;

    public IndexFile(String fileName, int hashSlotNum, int indexNum, long endPhyOffset, long endTimestamp) throws IOException {
        int fileTotalSize = 40 + hashSlotNum * HASH_SLOT_SIZE + indexNum * INDEX_SIZE;
        this.mapedFile = new MapedFile(fileName, fileTotalSize);
        this.fileChannel = this.mapedFile.getFileChannel();
        this.mappedByteBuffer = this.mapedFile.getMappedByteBuffer();
        this.hashSlotNum = hashSlotNum;
        this.indexNum = indexNum;
        ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
        this.indexHeader = new IndexHeader(byteBuffer);
        if (endPhyOffset > 0L) {
            this.indexHeader.setBeginPhyOffset(endPhyOffset);
            this.indexHeader.setEndPhyOffset(endPhyOffset);
        }
        if (endTimestamp > 0L) {
            this.indexHeader.setBeginTimestamp(endTimestamp);
            this.indexHeader.setEndTimestamp(endTimestamp);
        }
    }

    public String getFileName() {
        return this.mapedFile.getFileName();
    }

    public void load() {
        this.indexHeader.load();
    }

    public void flush() {
        long beginTime = System.currentTimeMillis();
        if (this.mapedFile.hold()) {
            this.indexHeader.updateByteBuffer();
            this.mappedByteBuffer.force();
            this.mapedFile.release();
            log.info("flush index file eclipse time(ms) " + (System.currentTimeMillis() - beginTime));
        }
    }

    public boolean isWriteFull() {
        return this.indexHeader.getIndexCount() >= this.indexNum;
    }

    public boolean destroy(long intervalForcibly) {
        return this.mapedFile.destroy(intervalForcibly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putKey(String key, long phyOffset, long storeTimestamp) {
        if (this.indexHeader.getIndexCount() < this.indexNum) {
            int keyHash = this.indexKeyHashMethod(key);
            int slotPos = keyHash % this.hashSlotNum;
            int absSlotPos = 40 + slotPos * HASH_SLOT_SIZE;
            FileLock fileLock = null;
            try {
                int slotValue = this.mappedByteBuffer.getInt(absSlotPos);
                if (slotValue <= INVALID_INDEX || slotValue > this.indexHeader.getIndexCount()) {
                    slotValue = INVALID_INDEX;
                }
                long timeDiff = storeTimestamp - this.indexHeader.getBeginTimestamp();
                timeDiff /= 1000L;
                if (this.indexHeader.getBeginTimestamp() <= 0L) {
                    timeDiff = 0L;
                } else if (timeDiff > Integer.MAX_VALUE) {
                    timeDiff = Integer.MAX_VALUE;
                } else if (timeDiff < 0L) {
                    timeDiff = 0L;
                }
                int absIndexPos = 40 + this.hashSlotNum * HASH_SLOT_SIZE + this.indexHeader.getIndexCount() * INDEX_SIZE;
                this.mappedByteBuffer.putInt(absIndexPos, keyHash);
                this.mappedByteBuffer.putLong(absIndexPos + 4, phyOffset);
                this.mappedByteBuffer.putInt(absIndexPos + 4 + 8, (int)timeDiff);
                this.mappedByteBuffer.putInt(absIndexPos + 4 + 8 + 4, slotValue);
                this.mappedByteBuffer.putInt(absSlotPos, this.indexHeader.getIndexCount());
                if (this.indexHeader.getIndexCount() <= 1) {
                    this.indexHeader.setBeginPhyOffset(phyOffset);
                    this.indexHeader.setBeginTimestamp(storeTimestamp);
                }
                this.indexHeader.incHashSlotCount();
                this.indexHeader.incIndexCount();
                this.indexHeader.setEndPhyOffset(phyOffset);
                this.indexHeader.setEndTimestamp(storeTimestamp);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.error("putKey exception, Key: " + key + " KeyHashCode: " + key.hashCode(), (Throwable)e);
            }
            finally {
                if (fileLock != null) {
                    try {
                        fileLock.release();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        log.warn("putKey index count " + this.indexHeader.getIndexCount() + " index max num " + this.indexNum);
        return false;
    }

    public long getBeginTimestamp() {
        return this.indexHeader.getBeginTimestamp();
    }

    public long getEndTimestamp() {
        return this.indexHeader.getEndTimestamp();
    }

    public long getEndPhyOffset() {
        return this.indexHeader.getEndPhyOffset();
    }

    public boolean isTimeMatched(long begin, long end) {
        boolean result = begin < this.indexHeader.getBeginTimestamp() && end > this.indexHeader.getEndTimestamp();
        result = result || begin >= this.indexHeader.getBeginTimestamp() && begin <= this.indexHeader.getEndTimestamp();
        result = result || end >= this.indexHeader.getBeginTimestamp() && end <= this.indexHeader.getEndTimestamp();
        return result;
    }

    public int indexKeyHashMethod(String key) {
        int keyHash = key.hashCode();
        int keyHashPositive = Math.abs(keyHash);
        if (keyHashPositive < 0) {
            keyHashPositive = 0;
        }
        return keyHashPositive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPhyOffset(List<Long> phyOffsets, String key, int maxNum, long begin, long end, boolean lock) {
        block20: {
            if (this.mapedFile.hold()) {
                int keyHash = this.indexKeyHashMethod(key);
                int slotPos = keyHash % this.hashSlotNum;
                int absSlotPos = 40 + slotPos * HASH_SLOT_SIZE;
                FileLock fileLock = null;
                try {
                    int slotValue;
                    if (lock) {
                        // empty if block
                    }
                    if ((slotValue = this.mappedByteBuffer.getInt(absSlotPos)) <= INVALID_INDEX || slotValue > this.indexHeader.getIndexCount()) break block20;
                    if (this.indexHeader.getIndexCount() <= 1) {
                        break block20;
                    }
                    int nextIndexToRead = slotValue;
                    while (phyOffsets.size() < maxNum) {
                        boolean timeMatched;
                        int absIndexPos = 40 + this.hashSlotNum * HASH_SLOT_SIZE + nextIndexToRead * INDEX_SIZE;
                        int keyHashRead = this.mappedByteBuffer.getInt(absIndexPos);
                        long phyOffsetRead = this.mappedByteBuffer.getLong(absIndexPos + 4);
                        long timeDiff = this.mappedByteBuffer.getInt(absIndexPos + 4 + 8);
                        int prevIndexRead = this.mappedByteBuffer.getInt(absIndexPos + 4 + 8 + 4);
                        if (timeDiff < 0L) {
                            break;
                        }
                        long timeRead = this.indexHeader.getBeginTimestamp() + (timeDiff *= 1000L);
                        boolean bl = timeMatched = timeRead >= begin && timeRead <= end;
                        if (keyHash == keyHashRead && timeMatched) {
                            phyOffsets.add(phyOffsetRead);
                        }
                        if (prevIndexRead <= INVALID_INDEX || prevIndexRead > this.indexHeader.getIndexCount() || prevIndexRead == nextIndexToRead) break;
                        if (timeRead < begin) {
                            break;
                        }
                        nextIndexToRead = prevIndexRead;
                    }
                }
                catch (Exception e) {
                    log.error("selectPhyOffset exception ", (Throwable)e);
                }
                finally {
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.mapedFile.release();
                }
            }
        }
    }
}

