/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store.index;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class IndexHeader {
    public static final int INDEX_HEADER_SIZE = 40;
    private static int BEGINTIMESTAMP_INDEX = 0;
    private static int ENDTIMESTAMP_INDEX = 8;
    private static int BEGINPHYOFFSET_INDEX = 16;
    private static int ENDPHYOFFSET_INDEX = 24;
    private static int HASHSLOTCOUNT_INDEX = 32;
    private static int INDEXCOUNT_INDEX = 36;
    private final ByteBuffer byteBuffer;
    private AtomicLong beginTimestamp = new AtomicLong(0L);
    private AtomicLong endTimestamp = new AtomicLong(0L);
    private AtomicLong beginPhyOffset = new AtomicLong(0L);
    private AtomicLong endPhyOffset = new AtomicLong(0L);
    private AtomicInteger hashSlotCount = new AtomicInteger(0);
    private AtomicInteger indexCount = new AtomicInteger(1);

    public IndexHeader(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void load() {
        this.beginTimestamp.set(this.byteBuffer.getLong(BEGINTIMESTAMP_INDEX));
        this.endTimestamp.set(this.byteBuffer.getLong(ENDTIMESTAMP_INDEX));
        this.beginPhyOffset.set(this.byteBuffer.getLong(BEGINPHYOFFSET_INDEX));
        this.endPhyOffset.set(this.byteBuffer.getLong(ENDPHYOFFSET_INDEX));
        this.hashSlotCount.set(this.byteBuffer.getInt(HASHSLOTCOUNT_INDEX));
        this.indexCount.set(this.byteBuffer.getInt(INDEXCOUNT_INDEX));
        if (this.indexCount.get() <= 0) {
            this.indexCount.set(1);
        }
    }

    public void updateByteBuffer() {
        this.byteBuffer.putLong(BEGINTIMESTAMP_INDEX, this.beginTimestamp.get());
        this.byteBuffer.putLong(ENDTIMESTAMP_INDEX, this.endTimestamp.get());
        this.byteBuffer.putLong(BEGINPHYOFFSET_INDEX, this.beginPhyOffset.get());
        this.byteBuffer.putLong(ENDPHYOFFSET_INDEX, this.endPhyOffset.get());
        this.byteBuffer.putInt(HASHSLOTCOUNT_INDEX, this.hashSlotCount.get());
        this.byteBuffer.putInt(INDEXCOUNT_INDEX, this.indexCount.get());
    }

    public long getBeginTimestamp() {
        return this.beginTimestamp.get();
    }

    public void setBeginTimestamp(long beginTimestamp) {
        this.beginTimestamp.set(beginTimestamp);
        this.byteBuffer.putLong(BEGINTIMESTAMP_INDEX, beginTimestamp);
    }

    public long getEndTimestamp() {
        return this.endTimestamp.get();
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp.set(endTimestamp);
        this.byteBuffer.putLong(ENDTIMESTAMP_INDEX, endTimestamp);
    }

    public long getBeginPhyOffset() {
        return this.beginPhyOffset.get();
    }

    public void setBeginPhyOffset(long beginPhyOffset) {
        this.beginPhyOffset.set(beginPhyOffset);
        this.byteBuffer.putLong(BEGINPHYOFFSET_INDEX, beginPhyOffset);
    }

    public long getEndPhyOffset() {
        return this.endPhyOffset.get();
    }

    public void setEndPhyOffset(long endPhyOffset) {
        this.endPhyOffset.set(endPhyOffset);
        this.byteBuffer.putLong(ENDPHYOFFSET_INDEX, endPhyOffset);
    }

    public AtomicInteger getHashSlotCount() {
        return this.hashSlotCount;
    }

    public void incHashSlotCount() {
        int value = this.hashSlotCount.incrementAndGet();
        this.byteBuffer.putInt(HASHSLOTCOUNT_INDEX, value);
    }

    public int getIndexCount() {
        return this.indexCount.get();
    }

    public void incIndexCount() {
        int value = this.indexCount.incrementAndGet();
        this.byteBuffer.putInt(INDEXCOUNT_INDEX, value);
    }
}

