/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store.index;

import com.alibaba.rocketmq.common.ServiceThread;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.sysflag.MessageSysFlag;
import com.alibaba.rocketmq.store.DefaultMessageStore;
import com.alibaba.rocketmq.store.DispatchRequest;
import com.alibaba.rocketmq.store.config.StorePathConfigHelper;
import com.alibaba.rocketmq.store.index.IndexFile;
import com.alibaba.rocketmq.store.index.QueryOffsetResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final DefaultMessageStore defaultMessageStore;
    private final int hashSlotNum;
    private final int indexNum;
    private final String storePath;
    private final ArrayList<IndexFile> indexFileList = new ArrayList();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private LinkedBlockingQueue<Object[]> requestQueue = new LinkedBlockingQueue(300000);

    public IndexService(DefaultMessageStore store) {
        this.defaultMessageStore = store;
        this.hashSlotNum = store.getMessageStoreConfig().getMaxHashSlotNum();
        this.indexNum = store.getMessageStoreConfig().getMaxIndexNum();
        this.storePath = StorePathConfigHelper.getStorePathIndex(store.getMessageStoreConfig().getStorePathRootDir());
    }

    public boolean load(boolean lastExitOK) {
        File dir = new File(this.storePath);
        Object[] files = dir.listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                try {
                    IndexFile f = new IndexFile(((File)file).getPath(), this.hashSlotNum, this.indexNum, 0L, 0L);
                    f.load();
                    if (!lastExitOK && f.getEndTimestamp() > this.defaultMessageStore.getStoreCheckpoint().getIndexMsgTimestamp()) {
                        f.destroy(0L);
                        continue;
                    }
                    log.info("load index file OK, " + f.getFileName());
                    this.indexFileList.add(f);
                }
                catch (IOException e) {
                    log.error("load file " + file + " error", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExpiredFile(long offset) {
        Object[] files = null;
        try {
            this.readWriteLock.readLock().lock();
            if (this.indexFileList.isEmpty()) {
                return;
            }
            long endPhyOffset = this.indexFileList.get(0).getEndPhyOffset();
            if (endPhyOffset < offset) {
                files = this.indexFileList.toArray();
            }
        }
        catch (Exception e) {
            log.error("destroy exception", (Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (files != null) {
            IndexFile f;
            ArrayList<IndexFile> fileList = new ArrayList<IndexFile>();
            for (int i = 0; i < files.length - 1 && (f = (IndexFile)files[i]).getEndPhyOffset() < offset; ++i) {
                fileList.add(f);
            }
            this.deleteExpiredFile(fileList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExpiredFile(List<IndexFile> files) {
        if (!files.isEmpty()) {
            try {
                this.readWriteLock.writeLock().lock();
                for (IndexFile file : files) {
                    boolean destroyed = file.destroy(3000L);
                    destroyed = destroyed && this.indexFileList.remove(file);
                    if (destroyed) continue;
                    log.error("deleteExpiredFile remove failed.");
                    break;
                }
            }
            catch (Exception e) {
                log.error("deleteExpiredFile has exception.", (Throwable)e);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.readWriteLock.readLock().lock();
            for (IndexFile f : this.indexFileList) {
                f.destroy(3000L);
            }
            this.indexFileList.clear();
        }
        catch (Exception e) {
            log.error("destroy exception", (Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryOffsetResult queryOffset(String topic, String key, int maxNum, long begin, long end) {
        long indexLastUpdatePhyoffset;
        long indexLastUpdateTimestamp;
        ArrayList<Long> phyOffsets;
        block10: {
            phyOffsets = new ArrayList<Long>(maxNum);
            indexLastUpdateTimestamp = 0L;
            indexLastUpdatePhyoffset = 0L;
            maxNum = Math.min(maxNum, this.defaultMessageStore.getMessageStoreConfig().getMaxMsgsNumBatch());
            try {
                this.readWriteLock.readLock().lock();
                if (this.indexFileList.isEmpty()) break block10;
                for (int i = this.indexFileList.size(); i > 0; --i) {
                    boolean lastFile;
                    IndexFile f = this.indexFileList.get(i - 1);
                    boolean bl = lastFile = i == this.indexFileList.size();
                    if (lastFile) {
                        indexLastUpdateTimestamp = f.getEndTimestamp();
                        indexLastUpdatePhyoffset = f.getEndPhyOffset();
                    }
                    if (f.isTimeMatched(begin, end)) {
                        f.selectPhyOffset(phyOffsets, this.buildKey(topic, key), maxNum, begin, end, lastFile);
                    }
                    if (f.getBeginTimestamp() < begin) {
                    } else if (phyOffsets.size() < maxNum) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.error("queryMsg exception", (Throwable)e);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return new QueryOffsetResult(phyOffsets, indexLastUpdateTimestamp, indexLastUpdatePhyoffset);
    }

    private String buildKey(String topic, String key) {
        return topic + "#" + key;
    }

    public void putRequest(Object[] reqs) {
        boolean offer = this.requestQueue.offer(reqs);
        if (!offer && log.isDebugEnabled()) {
            log.debug("putRequest index failed, {}", reqs);
        }
    }

    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStoped()) {
            try {
                Object[] req = this.requestQueue.poll(3000L, TimeUnit.MILLISECONDS);
                if (req == null) continue;
                this.buildIndex(req);
            }
            catch (Exception e) {
                log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void buildIndex(Object[] req) {
        boolean breakdown = false;
        IndexFile indexFile = this.retryGetAndCreateIndexFile();
        if (indexFile == null) {
            breakdown = true;
        } else {
            long endPhyOffset = indexFile.getEndPhyOffset();
            block4: for (Object o : req) {
                String[] keyset;
                DispatchRequest msg = (DispatchRequest)o;
                String topic = msg.getTopic();
                String keys = msg.getKeys();
                if (msg.getCommitLogOffset() < endPhyOffset) continue;
                int tranType = MessageSysFlag.getTransactionValue((int)msg.getSysFlag());
                switch (tranType) {
                    case 0: 
                    case 4: {
                        break;
                    }
                    case 8: 
                    case 12: {
                        continue block4;
                    }
                }
                if (keys == null || keys.length() <= 0) continue;
                for (String key : keyset = keys.split(" ")) {
                    if (key.length() <= 0) continue;
                    boolean ok = indexFile.putKey(this.buildKey(topic, key), msg.getCommitLogOffset(), msg.getStoreTimestamp());
                    while (!ok) {
                        log.warn("index file full, so create another one, " + indexFile.getFileName());
                        indexFile = this.retryGetAndCreateIndexFile();
                        if (null == indexFile) {
                            breakdown = true;
                            break block4;
                        }
                        ok = indexFile.putKey(this.buildKey(topic, key), msg.getCommitLogOffset(), msg.getStoreTimestamp());
                    }
                }
            }
        }
        if (breakdown) {
            log.error("build index error, stop building index");
        }
    }

    public IndexFile retryGetAndCreateIndexFile() {
        IndexFile indexFile = null;
        for (int times = 0; null == indexFile && times < 3 && null == (indexFile = this.getAndCreateLastIndexFile()); ++times) {
            try {
                log.error("try to create index file, " + times + " times");
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (null == indexFile) {
            this.defaultMessageStore.getAccessRights().makeIndexFileError();
            log.error("mark index file can not build flag");
        }
        return indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexFile getAndCreateLastIndexFile() {
        IndexFile indexFile = null;
        IndexFile prevIndexFile = null;
        long lastUpdateEndPhyOffset = 0L;
        long lastUpdateIndexTimestamp = 0L;
        this.readWriteLock.readLock().lock();
        if (!this.indexFileList.isEmpty()) {
            IndexFile tmp = this.indexFileList.get(this.indexFileList.size() - 1);
            if (!tmp.isWriteFull()) {
                indexFile = tmp;
            } else {
                lastUpdateEndPhyOffset = tmp.getEndPhyOffset();
                lastUpdateIndexTimestamp = tmp.getEndTimestamp();
                prevIndexFile = tmp;
            }
        }
        this.readWriteLock.readLock().unlock();
        if (indexFile == null) {
            try {
                String fileName = this.storePath + File.separator + UtilAll.timeMillisToHumanString((long)System.currentTimeMillis());
                indexFile = new IndexFile(fileName, this.hashSlotNum, this.indexNum, lastUpdateEndPhyOffset, lastUpdateIndexTimestamp);
                this.readWriteLock.writeLock().lock();
                this.indexFileList.add(indexFile);
            }
            catch (Exception e) {
                log.error("getLastIndexFile exception ", (Throwable)e);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            if (indexFile != null) {
                final IndexFile flushThisFile = prevIndexFile;
                Thread flushThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IndexService.this.flush(flushThisFile);
                    }
                }, "FlushIndexFileThread");
                flushThread.setDaemon(true);
                flushThread.start();
            }
        }
        return indexFile;
    }

    public void flush(IndexFile f) {
        if (null == f) {
            return;
        }
        long indexMsgTimestamp = 0L;
        if (f.isWriteFull()) {
            indexMsgTimestamp = f.getEndTimestamp();
        }
        f.flush();
        if (indexMsgTimestamp > 0L) {
            this.defaultMessageStore.getStoreCheckpoint().setIndexMsgTimestamp(indexMsgTimestamp);
            this.defaultMessageStore.getStoreCheckpoint().flush();
        }
    }

    public String getServiceName() {
        return IndexService.class.getSimpleName();
    }
}

