/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.alibaba.rocketmq.common.MQVersion;
import com.alibaba.rocketmq.common.conflict.PackageConflictDetect;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.alibaba.rocketmq.srvutil.ServerUtil;
import com.alibaba.rocketmq.tools.command.SubCommand;
import com.alibaba.rocketmq.tools.command.broker.BrokerStatusSubCommand;
import com.alibaba.rocketmq.tools.command.broker.CleanExpiredCQSubCommand;
import com.alibaba.rocketmq.tools.command.broker.UpdateBrokerConfigSubCommand;
import com.alibaba.rocketmq.tools.command.cluster.ClusterListSubCommand;
import com.alibaba.rocketmq.tools.command.connection.ConsumerConnectionSubCommand;
import com.alibaba.rocketmq.tools.command.connection.ProducerConnectionSubCommand;
import com.alibaba.rocketmq.tools.command.consumer.ConsumerProgressSubCommand;
import com.alibaba.rocketmq.tools.command.consumer.ConsumerStatusSubCommand;
import com.alibaba.rocketmq.tools.command.consumer.DeleteSubscriptionGroupCommand;
import com.alibaba.rocketmq.tools.command.consumer.StartMonitoringSubCommand;
import com.alibaba.rocketmq.tools.command.consumer.UpdateSubGroupSubCommand;
import com.alibaba.rocketmq.tools.command.message.CheckMsgSubCommand;
import com.alibaba.rocketmq.tools.command.message.PrintMessageSubCommand;
import com.alibaba.rocketmq.tools.command.message.QueryMsgByIdSubCommand;
import com.alibaba.rocketmq.tools.command.message.QueryMsgByKeySubCommand;
import com.alibaba.rocketmq.tools.command.message.QueryMsgByOffsetSubCommand;
import com.alibaba.rocketmq.tools.command.namesrv.DeleteKvConfigCommand;
import com.alibaba.rocketmq.tools.command.namesrv.UpdateKvConfigCommand;
import com.alibaba.rocketmq.tools.command.namesrv.WipeWritePermSubCommand;
import com.alibaba.rocketmq.tools.command.offset.CloneGroupOffsetCommand;
import com.alibaba.rocketmq.tools.command.offset.ResetOffsetByTimeCommand;
import com.alibaba.rocketmq.tools.command.stats.StatsAllSubCommand;
import com.alibaba.rocketmq.tools.command.topic.DeleteTopicSubCommand;
import com.alibaba.rocketmq.tools.command.topic.TopicListSubCommand;
import com.alibaba.rocketmq.tools.command.topic.TopicRouteSubCommand;
import com.alibaba.rocketmq.tools.command.topic.TopicStatusSubCommand;
import com.alibaba.rocketmq.tools.command.topic.UpdateOrderConfCommand;
import com.alibaba.rocketmq.tools.command.topic.UpdateTopicSubCommand;
import com.alibaba.rocketmq.tools.github.SyncDocsToGithubSubCommand;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.slf4j.LoggerFactory;

public class MQAdminStartup {
    protected static List<SubCommand> subCommandList = new ArrayList<SubCommand>();

    public static void initCommand() {
        MQAdminStartup.initCommand(new UpdateTopicSubCommand());
        MQAdminStartup.initCommand(new DeleteTopicSubCommand());
        MQAdminStartup.initCommand(new UpdateSubGroupSubCommand());
        MQAdminStartup.initCommand(new DeleteSubscriptionGroupCommand());
        MQAdminStartup.initCommand(new UpdateBrokerConfigSubCommand());
        MQAdminStartup.initCommand(new TopicRouteSubCommand());
        MQAdminStartup.initCommand(new TopicStatusSubCommand());
        MQAdminStartup.initCommand(new BrokerStatusSubCommand());
        MQAdminStartup.initCommand(new QueryMsgByIdSubCommand());
        MQAdminStartup.initCommand(new QueryMsgByKeySubCommand());
        MQAdminStartup.initCommand(new QueryMsgByOffsetSubCommand());
        MQAdminStartup.initCommand(new PrintMessageSubCommand());
        MQAdminStartup.initCommand(new ProducerConnectionSubCommand());
        MQAdminStartup.initCommand(new ConsumerConnectionSubCommand());
        MQAdminStartup.initCommand(new ConsumerProgressSubCommand());
        MQAdminStartup.initCommand(new ConsumerStatusSubCommand());
        MQAdminStartup.initCommand(new CloneGroupOffsetCommand());
        MQAdminStartup.initCommand(new ClusterListSubCommand());
        MQAdminStartup.initCommand(new TopicListSubCommand());
        MQAdminStartup.initCommand(new UpdateKvConfigCommand());
        MQAdminStartup.initCommand(new DeleteKvConfigCommand());
        MQAdminStartup.initCommand(new WipeWritePermSubCommand());
        MQAdminStartup.initCommand(new ResetOffsetByTimeCommand());
        MQAdminStartup.initCommand(new UpdateOrderConfCommand());
        MQAdminStartup.initCommand(new CleanExpiredCQSubCommand());
        MQAdminStartup.initCommand(new StartMonitoringSubCommand());
        MQAdminStartup.initCommand(new CheckMsgSubCommand());
        MQAdminStartup.initCommand(new StatsAllSubCommand());
        MQAdminStartup.initCommand(new SyncDocsToGithubSubCommand());
    }

    public static void initCommand(SubCommand command) {
        subCommandList.add(command);
    }

    public static void main(String[] args) {
        MQAdminStartup.main0(args, null);
    }

    public static void main0(String[] args, RPCHook rpcHook) {
        System.setProperty(RemotingCommand.RemotingVersionKey, Integer.toString(MQVersion.CurrentVersion));
        PackageConflictDetect.detectFastjson();
        MQAdminStartup.initCommand();
        try {
            MQAdminStartup.initLogback();
            switch (args.length) {
                case 0: {
                    MQAdminStartup.printHelp();
                    break;
                }
                case 2: {
                    if (args[0].equals("help")) {
                        SubCommand cmd = MQAdminStartup.findSubCommand(args[1]);
                        if (cmd != null) {
                            Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
                            if ((options = cmd.buildCommandlineOptions(options)) != null) {
                                ServerUtil.printCommandLineHelp((String)("mqadmin " + cmd.commandName()), (Options)options);
                            }
                            break;
                        }
                        System.out.println("The sub command '" + args[1] + "' not exist.");
                        break;
                    }
                }
                default: {
                    SubCommand cmd = MQAdminStartup.findSubCommand(args[0]);
                    if (cmd != null) {
                        String[] subargs = MQAdminStartup.parseSubArgs(args);
                        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
                        CommandLine commandLine = ServerUtil.parseCmdLine((String)("mqadmin " + cmd.commandName()), (String[])subargs, (Options)cmd.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
                        if (null == commandLine) {
                            System.exit(-1);
                            return;
                        }
                        if (commandLine.hasOption('n')) {
                            String namesrvAddr = commandLine.getOptionValue('n');
                            System.setProperty("rocketmq.namesrv.addr", namesrvAddr);
                        }
                        cmd.execute(commandLine, options, rpcHook);
                        break;
                    }
                    System.out.println("The sub command '" + args[0] + "' not exist.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initLogback() throws JoranException {
        String rocketmqHome = System.getProperty("rocketmq.home.dir", System.getenv("ROCKETMQ_HOME"));
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        configurator.doConfigure(rocketmqHome + "/conf/logback_tools.xml");
    }

    private static String[] parseSubArgs(String[] args) {
        if (args.length > 1) {
            String[] result = new String[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                result[i] = args[i + 1];
            }
            return result;
        }
        return null;
    }

    private static SubCommand findSubCommand(String name) {
        for (SubCommand cmd : subCommandList) {
            if (!cmd.commandName().toUpperCase().equals(name.toUpperCase())) continue;
            return cmd;
        }
        return null;
    }

    private static void printHelp() {
        System.out.println("The most commonly used mqadmin commands are:");
        for (SubCommand cmd : subCommandList) {
            System.out.printf("   %-20s %s\n", cmd.commandName(), cmd.commandDesc());
        }
        System.out.println("\nSee 'mqadmin help <command>' for more information on a specific command.");
    }
}

