/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.message;

import com.alibaba.rocketmq.client.consumer.DefaultMQPullConsumer;
import com.alibaba.rocketmq.client.consumer.PullResult;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PrintMessageSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "printMsg";
    }

    @Override
    public String commandDesc() {
        return "Print Message Detail";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("t", "topic", true, "topic name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("c", "charsetName ", true, "CharsetName(eg: UTF-8\u3001GBK)");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "subExpression ", true, "Subscribe Expression(eg: TagA || TagB)");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("b", "beginTimestamp ", true, "Begin timestamp[currentTimeMillis|yyyy-MM-dd#HH:mm:ss:SSS]");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("e", "endTimestamp ", true, "End timestamp[currentTimeMillis|yyyy-MM-dd#HH:mm:ss:SSS]");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static void printMessage(List<MessageExt> msgs, String charsetName) {
        for (MessageExt msg : msgs) {
            try {
                System.out.printf("MSGID: %s %s BODY: %s\n", msg.getMsgId(), msg.toString(), new String(msg.getBody(), charsetName));
            }
            catch (UnsupportedEncodingException e) {}
        }
    }

    public static long timestampFormat(String value) {
        long timestamp = 0L;
        try {
            timestamp = Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            timestamp = UtilAll.parseDate((String)value, (String)"yyyy-MM-dd#HH:mm:ss:SSS").getTime();
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer("TOOLS_CONSUMER", rpcHook);
        try {
            String topic = commandLine.getOptionValue('t').trim();
            String charsetName = !commandLine.hasOption('c') ? "UTF-8" : commandLine.getOptionValue('c').trim();
            String subExpression = !commandLine.hasOption('s') ? "*" : commandLine.getOptionValue('s').trim();
            consumer.start();
            Set mqs = consumer.fetchSubscribeMessageQueues(topic);
            block11: for (MessageQueue mq : mqs) {
                long timeValue;
                String timestampStr;
                long minOffset = consumer.minOffset(mq);
                long maxOffset = consumer.maxOffset(mq);
                if (commandLine.hasOption('b')) {
                    timestampStr = commandLine.getOptionValue('b').trim();
                    timeValue = PrintMessageSubCommand.timestampFormat(timestampStr);
                    minOffset = consumer.searchOffset(mq, timeValue);
                }
                if (commandLine.hasOption('e')) {
                    timestampStr = commandLine.getOptionValue('e').trim();
                    timeValue = PrintMessageSubCommand.timestampFormat(timestampStr);
                    maxOffset = consumer.searchOffset(mq, timeValue);
                }
                long offset = minOffset;
                while (offset < maxOffset) {
                    try {
                        PullResult pullResult = consumer.pull(mq, subExpression, offset, 32);
                        offset = pullResult.getNextBeginOffset();
                        switch (pullResult.getPullStatus()) {
                            case FOUND: {
                                PrintMessageSubCommand.printMessage(pullResult.getMsgFoundList(), charsetName);
                                break;
                            }
                            case NO_MATCHED_MSG: 
                            case NO_NEW_MSG: 
                            case OFFSET_ILLEGAL: {
                                continue block11;
                            }
                        }
                    }
                    catch (Exception e) {
                        continue block11;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            consumer.shutdown();
        }
    }
}

